<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "banks".
 *
 * @property int $bid
 * @property string $bank
 * @property int $cid
 * @property double $balance
 * @property string $created_at
 * @property string $updated_at
 */
class Banks extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'banks';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['bank', 'cid', 'balance'], 'required'],
            [['cid'], 'integer'],
            [['balance'], 'number'],
            [['created_at', 'updated_at'], 'safe'],
            [['bank'], 'string', 'max' => 200],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'bid' => 'Bid',
            'bank' => 'Bank',
            'cid' => 'Cid',
            'balance' => 'Balance',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }
}
