<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "ledger".
 *
 * @property int $id
 * @property int $cid
 * @property int $department
 * @property string $description
 * @property double $credit
 * @property double $amount_paid
 * @property double $debit
 * @property string $transaction_id
 * @property string $vendor
 * @property string $created_at
 * @property string $updated_at
 * @property int $ptype 
 * @property int $bank
 * @property int $aorb
 * @property string $tlink
 */
class Ledger extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'ledger';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cid', 'department', 'description', 'credit', 'debit', 'transaction_id', 'vendor'], 'required'],
            [['cid', 'department','open','ptype','bank','aorb'], 'integer'],
            [['description','tlink'], 'string'],
            [['credit', 'amount_paid', 'debit'], 'number'],
            [['created_at', 'updated_at'], 'safe'],
            [['transaction_id'], 'string', 'max' => 200],
            [['tlink'], 'string', 'max' => 220],
            [['vendor'], 'string', 'max' => 225],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'department' => 'Department',
            'description' => 'Description',
            'credit' => 'Credit',
            'amount_paid' => 'Amount Paid',
            'debit' => 'Debit',
            'transaction_id' => 'Transaction ID',
            'vendor' => 'Vendor',
            'bank' => 'Bank',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }

    function getLabel()
    {
        return ucwords(Vendors::findOne($this->vendor)->name);
    }

    // public function named
    // {
    // return $this->hasMany(::className(), ['a_id' => 'id_A']);
    // }

    public function getCustomer()
    {
        return $this->hasOne(Customers::className(), ['id' => 'vendor']);
    }
}
