<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "notifications".
 *
 * @property int $id
 * @property int $action_by
 * @property int $notify
 * @property string $link
 * @property string $created_at
 * @property string $updated_at
 * @property int $status
 * @property string $message
 * @property int $cid
 * @property int $req_id
 * @property int $doc_id
 * @property int $workflow_id
 * @property int $concluded
 * @property int $rejected
 */
class Notifications extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'notifications';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['action_by', 'notify', 'link', 'cid', 'req_id', 'doc_id', 'workflow_id', 'concluded', 'rejected'], 'required'],
            [['action_by', 'notify', 'status', 'cid', 'req_id', 'doc_id', 'workflow_id', 'concluded', 'rejected'], 'integer'],
            [['created_at', 'updated_at'], 'safe'],
            [['link', 'message'], 'string', 'max' => 200],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'action_by' => 'Action By',
            'notify' => 'Notify',
            'link' => 'Link',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'status' => 'Status',
            'message' => 'Message',
            'cid' => 'Cid',
            'req_id' => 'Req ID',
            'doc_id' => 'Doc ID',
            'workflow_id' => 'Workflow ID',
            'concluded' => 'Concluded',
            'rejected' => 'Rejected',
        ];
    }
}
