<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "requisitions_del".
 *
 * @property int $rrid
 * @property int $id
 * @property int $cid clients id on the system
 * @property string $title title of requisition
 * @property int $originating_department department where requisition originated
 * @property int $raised_by saff who raised or submitted the requisition
 * @property int $workflow_id id of the workflow used to run this transaction
 * @property int $status id of the staff whose turn it is to act on the requisition. the person with this id will recived an action required notification
 * @property int $instrument instrument to be generated and used by the person whose turn it is to work on the request or requisition
 * @property string $not_seen id of all the people along the workflow who need to recieve notifications about progress of the requisition. may be removed from the string as they see or view the notification
 * @property int $concluded default is 0 but set to one on conclusion of workflow process
 * @property int $rejected
 * @property string $requested_item
 * @property string $transaction_id automatically generated transacion id
 * @property int $current_index
 * @property string $to_be_notified
 * @property int $task_type
 * @property int $dsender_id id of the person who will be releasing items in a transfer request scenerio
 * @property string $created_at
 * @property string $updated_at
 */
class RequisitionsDel extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'requisitions_del';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'cid', 'originating_department', 'raised_by', 'workflow_id', 'status', 'instrument', 'not_seen', 'transaction_id', 'task_type'], 'required'],
            [['id', 'cid', 'originating_department', 'raised_by', 'workflow_id', 'status', 'instrument', 'concluded', 'rejected', 'current_index', 'task_type', 'dsender_id'], 'integer'],
            [['not_seen', 'requested_item', 'to_be_notified'], 'string'],
            [['created_at', 'updated_at'], 'safe'],
            [['title', 'transaction_id'], 'string', 'max' => 225],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'rrid' => 'Rrid',
            'id' => 'ID',
            'cid' => 'Cid',
            'title' => 'Title',
            'originating_department' => 'Originating Department',
            'raised_by' => 'Raised By',
            'workflow_id' => 'Workflow ID',
            'status' => 'Status',
            'instrument' => 'Instrument',
            'not_seen' => 'Not Seen',
            'concluded' => 'Concluded',
            'rejected' => 'Rejected',
            'requested_item' => 'Requested Item',
            'transaction_id' => 'Transaction ID',
            'current_index' => 'Current Index',
            'to_be_notified' => 'To Be Notified',
            'task_type' => 'Task Type',
            'dsender_id' => 'Dsender ID',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }
}
