<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "shop_history".
 *
 * @property int $id
 * @property string $barcode
 * @property int $cid
 * @property string $name
 * @property string $description
 * @property double $quantity
 * @property double $supply_price
 * @property int $reorder
 * @property int $staff
 * @property double $price
 * @property string $created_at
 * @property string $updated_at
 * @property int $category
 * @property int $supplier
 * @property string $photo
 * @property int $countable
 * @property int $item_id
 * @property int $received_by
 * @property int $issued_by
 * @property int $type
 * @property int $customer
 * @property int $transaction_id
 */
class ShopHistory extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'shop_history';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cid', 'staff', 'price', 'countable', 'item_id', 'received_by', 'issued_by', 'transaction_id'], 'required'],
            [['cid', 'reorder', 'staff', 'category', 'supplier', 'countable', 'item_id', 'received_by', 'issued_by', 'type', 'customer', 'transaction_id'], 'integer'],
            [['description'], 'string'],
            [['quantity', 'supply_price', 'price'], 'number'],
            [['created_at', 'updated_at'], 'safe'],
            [['barcode'], 'string', 'max' => 200],
            [['name'], 'string', 'max' => 250],
            [['photo'], 'string', 'max' => 100],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'barcode' => 'Barcode',
            'cid' => 'Cid',
            'name' => 'Name',
            'description' => 'Description',
            'quantity' => 'Quantity',
            'supply_price' => 'Supply Price',
            'reorder' => 'Reorder',
            'staff' => 'Staff',
            'price' => 'Price',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'category' => 'Category',
            'supplier' => 'Supplier',
            'photo' => 'Photo',
            'countable' => 'Countable',
            'item_id' => 'Item ID',
            'received_by' => 'Received By',
            'issued_by' => 'Issued By',
            'type' => 'Type',
            'customer' => 'Customer',
            'transaction_id' => 'Transaction ID',
        ];
    }
}
