<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "stores_history".
 *
 * @property int $id
 * @property int $cid
 * @property string $name
 * @property double $standing_quantity
 * @property string $particulars
 * @property string $received_date
 * @property string $issued_date
 * @property int $recieved_by
 * @property int $issued_by
 * @property int $given_to
 * @property string $description
 * @property string $transaction_id
 * @property double $balance
 * @property string $units
 * @property int $item_id
 * @property double $transaction_quantity
 * @property int $type
 */
class StoresHistory extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'stores_history';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cid', 'name', 'transaction_id', 'item_id', 'transaction_quantity','type'], 'required'],
            [['cid', 'recieved_by', 'issued_by', 'given_to', 'item_id', 'type','vendor'], 'integer'],
            [['name', 'particulars', 'description'], 'string'],
            [['standing_quantity', 'balance', 'transaction_quantity'], 'number'],
            [['received_date', 'issued_date'], 'safe'],
            [['transaction_id'], 'string', 'max' => 200],
            [['units'], 'string', 'max' => 50],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'name' => 'Name',
            'standing_quantity' => 'Standing Quantity',
            'particulars' => 'Particulars',
            'received_date' => 'Received Date',
            'issued_date' => 'Issued Date',
            'recieved_by' => 'Recieved By',
            'issued_by' => 'Issued By',
            'given_to' => 'Given To',
            'description' => 'Description',
            'transaction_id' => 'Transaction ID',
            'balance' => 'Balance',
            'units' => 'Units',
            'item_id' => 'Item ID',
            'transaction_quantity' => 'Transaction Quantity',
            'type' => 'Type',
        ];
    }

    public function getvix()
    {
        return $this->hasOne(Vendors::className(), ['id' => 'vendor']);
    }

    public function getcix()
    {
        return $this->hasOne(\backend\models\User::className(), ['id' => 'recieved_by']);
    }

     public function getitem()
    {
        return $this->hasOne(Stores::className(), ['id' => 'item_id']);
    }
}
