<?php

namespace frontend\modules\hr\models;

use Yii;

/**
 * This is the model class for table "admin_details".
 *
 * @property int $id
 * @property string $subject
 * @property string $subject_details
 * @property int $staff_id
 * @property string $created_at
 */
class AdminDetails extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'admin_details';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['subject', 'subject_details', 'staff_id', 'created_at'], 'required'],
            [['subject_details'], 'string'],
            [['staff_id'], 'integer'],
            [['subject'], 'string', 'max' => 255],
            [['created_at'], 'string', 'max' => 12],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'subject' => 'Subject',
            'subject_details' => 'Subject Details',
            'staff_id' => 'Staff ID',
            'created_at' => 'Created At',
        ];
    }

    /**
     * {@inheritdoc}
     * @return AdminDetailsQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new AdminDetailsQuery(get_called_class());
    }
}
