<?php

namespace frontend\modules\hr\models;

use Yii;

/**
 * This is the model class for table "client_account".
 *
 * @property int $id
 * @property int $cid
 * @property string $client_name
 * @property string $address
 * @property string $company_number
 * @property string $email
 * @property string $contact_person
 * @property string $created_at
 * @property string $contact_number
 */
class ClientAccount extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'client_account';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cid', 'client_name', 'address', 'created_at'], 'required'],
            [['cid'], 'integer'],
            [['address'], 'string'],
            [['client_name', 'contact_person'], 'string', 'max' => 255],
            [['company_number', 'contact_number'], 'string', 'max' => 17],
            [['email'], 'string', 'max' => 60],
            [['created_at'], 'string', 'max' => 15],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'client_name' => 'Client Name',
            'address' => 'Address',
            'company_number' => 'Company Number',
            'email' => 'Email',
            'contact_person' => 'Contact Person',
            'created_at' => 'Created At',
            'contact_number' => 'Contact Number',
        ];
    }

    /**
     * {@inheritdoc}
     * @return ClientAccountQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new ClientAccountQuery(get_called_class());
    }
}
