<?php

namespace frontend\modules\hr\models;

use Yii;

/**
 * This is the model class for table "guarantor".
 *
 * @property int $id
 * @property int $cid
 * @property int $staff_id
 * @property string $name
 * @property string $address
 * @property string $phone
 * @property string $employer
 * @property string $employer_addrress
 * @property string $employer_phone
 * @property string $position
 * @property string $department
 * @property string $length_of_service
 */
class Guarantor extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'guarantor';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cid', 'staff_id', 'name', 'address', 'phone', 'employer', 'employer_addrress', 'employer_phone', 'position', 'department', 'length_of_service'], 'required'],
            [['cid', 'staff_id'], 'integer'],
            [['address', 'employer_addrress'], 'string'],
            [['name', 'employer', 'position', 'department', 'length_of_service'], 'string', 'max' => 255],
            [['phone', 'employer_phone'], 'string', 'max' => 30],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'staff_id' => 'Staff ID',
            'name' => 'Name',
            'address' => 'Address',
            'phone' => 'Phone',
            'employer' => 'Employer',
            'employer_addrress' => 'Employer Addrress',
            'employer_phone' => 'Employer Phone',
            'position' => 'Position',
            'department' => 'Department',
            'length_of_service' => 'Length Of Service',
        ];
    }

    /**
     * {@inheritdoc}
     * @return GuarantorQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new GuarantorQuery(get_called_class());
    }
}
