<?php

namespace frontend\modules\hr\models;

use Yii;

/**
 * This is the model class for table "past_employment_details".
 *
 * @property int $id
 * @property string $name_of_employer
 * @property int $cid
 * @property string $address
 * @property string $phone
 * @property int $employment_type
 * @property string $employment_period
 * @property string $last_position_held
 * @property int $staff_id
 */
class PastEmploymentDetails extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'past_employment_details';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name_of_employer', 'cid', 'address', 'phone', 'employment_type', 'employment_period', 'last_position_held', 'staff_id'], 'required'],
            [['cid', 'employment_type', 'staff_id'], 'integer'],
            [['address'], 'string'],
            [['name_of_employer', 'last_position_held'], 'string', 'max' => 255],
            [['phone'], 'string', 'max' => 17],
            [['employment_period'], 'string', 'max' => 50],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name_of_employer' => 'Name Of Employer',
            'cid' => 'Cid',
            'address' => 'Address',
            'phone' => 'Phone',
            'employment_type' => 'Employment Type',
            'employment_period' => 'Employment Period',
            'last_position_held' => 'Last Position Held',
            'staff_id' => 'Staff ID',
        ];
    }

    /**
     * {@inheritdoc}
     * @return PastEmploymentDetailsQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new PastEmploymentDetailsQuery(get_called_class());
    }
}
