<?php

namespace frontend\modules\hr\models;

use Yii;

/**
 * This is the model class for table "personal_details".
 *
 * @property int $id
 * @property int $cid
 * @property string $surname
 * @property string $firstname
 * @property string $other_names
 * @property string $dob
 * @property int $nationality
 * @property string $nin
 * @property string $nir
 * @property string $tin
 * @property int $marital_status
 * @property string $name_of_spouse
 * @property string $residential_address
 * @property string $permanent_home_address
 * @property string $telephone
 * @property string $email
 * @property int $gender
 * @property string $address_of_spouse
 * @property int $account_type
 * @property int $account_number
 * @property string $spouse_telephone
 * @property string $name_of_banker
 * @property string $name_of_PFA
 * @property string $name_of_PFC
 * @property string $RSA_number
 * @property int $approved
 * @property int $staff_id
 * @property int $activate_attendance 
 */
class PersonalDetails extends \yii\db\ActiveRecord
{
    public $sectoral;
    public $emtype;
    public $client;
    public $unit;
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'personal_details';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cid', 'surname', 'firstname', 'dob', 'nationality', 'marital_status', 'residential_address', 'telephone', 'gender', 'account_type','permanent_home_address','activate_attendance'], 'required'],
            [['cid', 'nationality', 'marital_status', 'gender', 'account_type', 'approved','staff_id','activate_attendance'], 'integer'],
            [['residential_address', 'address_of_spouse','permanent_home_address'], 'string'],
            [['surname', 'firstname', 'other_names', 'nin', 'nir', 'tin', 'name_of_spouse', 'email', 'name_of_banker', 'name_of_PFA', 'name_of_PFC', 'RSA_number','client'], 'string', 'max' => 255],
            [['dob'], 'string', 'max' => 15],
            [['account_number'], 'string', 'max' => 17],
            [['telephone'], 'string', 'max' => 25],
            [['spouse_telephone'], 'string', 'max' => 20],
            [['sectoral'], 'string', 'min'=>1],
            [['emtype'], 'string', 'min'=>1],
            [['client'], 'string', 'min'=>1],
            // [['surname','firstname','email'], 'unique'],
             // [['email'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'surname' => 'Surname',
            'firstname' => 'Firstname',
            'other_names' => 'Other Names',
            'dob' => 'Dob',
            'nationality' => 'Nationality',
            'nin' => 'Nin',
            'nir' => 'Nir',
            'tin' => 'Tin',
            'marital_status' => 'Marital Status',
            'name_of_spouse' => 'Name Of Spouse',
            'residential_address' => 'Residential Address',
            'telephone' => 'Telephone',
            'email' => 'Email',
            'gender' => 'Gender',
            'address_of_spouse' => 'Address Of Spouse',
            'account_type' => 'Account Type',
            'account_number' => 'Account Number',
            'spouse_telephone' => 'Spouse Telephone',
            'name_of_banker' => 'Name Of Banker',
            'name_of_PFA' => 'Name Of  Pfa',
            'name_of_PFC' => 'Name Of  Pfc',
            'RSA_number' => 'Rsa Number',
            'approved' => 'Approved',
            'staff_id' => 'Staff',
        ];
    }

    /**
     * {@inheritdoc}
     * @return PersonalDetailsQuery the active query used by this AR class.
     */
    public static function find()
    {
        return new PersonalDetailsQuery(get_called_class());
    }

    public function getEdetails()
    {
        return $this->hasOne(EmploymentDetails::class,['staff_id'=>'id']);
    }

    public function getAdetails()
    {
        return $this->hasMany(Attendance::class,['staff'=>'id']);
    }

    // public function getCdetails()
    // {
    //     return $this->hasOne(ClientAccount::class,['id'=>'client'];    // }


    public function unique_staff($attribute,$params)
    {
       
        //$checked=User::model()->find('role=:ba and cid=:sh',array(':ba'=>$this->role,':sh'=>$this->cid));
        $checked=PersonalDetails::find()->where(['cid'=>$this->cid,'firstname'=>$this->firstname,'surname'=>$this->surname])->one();
       // $checked=User::find()->where(['place'=>$this->place])->andWhere(['cid'=>$this->cid])->andWhere(['!=','place','Group Member'])->andWhere(['department'=>$this->department])->one();
        if($checked!=null)
        {
             // if($this->place==1){ $place='Group head'; }
             $this->addError('surname',
            'A staff  with this '.$this->username.' and '.$this->firstname.' already exists');
        }
        
    }

    public function getFullName()
    {
        return $this->surname.' '.$this->firstname;
    }

   

   
}
