<?php

namespace frontend\modules\hr\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use frontend\modules\hr\models\PersonalDetails;

/**
 * PersonalDetailsSearch represents the model behind the search form of `frontend\modules\hr\models\PersonalDetails`.
 */
class PersonalDetailsSearch2 extends PersonalDetails
{
    public $sectoral;
    public $emtype;
    public $approved;
    public $unit;
    public $client;
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id', 'cid', 'nationality', 'marital_status', 'name_of_spouse', 'residential_address', 'gender', 'account_type', 'account_number'], 'integer'],
            [['surname', 'firstname', 'dob', 'nin', 'nir', 'tin', 'telephone', 'email', 'address_of_spouse', 'spouse_telephone', 'name_of_banker', 'name_of_PFA', 'name_of_PFC', 'RSA_number','other_names','sectoral','emtype','approved','client','unit'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = PersonalDetails::find();

        // add conditions that should always apply here
        // $query->leftJoin('employment_details',['employment_details.staff_id'=>'personal_details.id']);
        $query->joinWith(['edetails']);

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);
        

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'personal_details.id' => $this->id,
            'personal_details.cid' => Yii::$app->user->identity->cid,
            'personal_details.other_names' => $this->other_names,
            'personal_details.nationality' => $this->nationality,
            'personal_details.marital_status' => $this->marital_status,
            'personal_details.name_of_spouse' => $this->name_of_spouse,
            'personal_details.residential_address' => $this->residential_address,
            'personal_details.gender' => $this->gender,
            'personal_details.account_type' => $this->account_type,
            'personal_details.account_number' => $this->account_number,
            'employment_details.section' => $this->sectoral,
            'employment_details.employment_type' => $this->emtype,
            'personal_details.approved' => 2,
            // 'employment_details.location' => $this->client,
            // 'employment_details.location' => $this->unit,
        ]);

        $query->andFilterWhere(['like', 'personal_details.surname', $this->surname])
            ->andFilterWhere(['like', 'personal_details.firstname', $this->firstname])
            ->andFilterWhere(['like', 'personal_details.dob', $this->dob])
            ->andFilterWhere(['like', 'personal_details.nin', $this->nin])
            ->andFilterWhere(['like', 'personal_details.nir', $this->nir])
            ->andFilterWhere(['like', 'personal_details.tin', $this->tin])
            ->andFilterWhere(['like', 'personal_details.telephone', $this->telephone])
            ->andFilterWhere(['like', 'personal_details.email', $this->email])
            ->andFilterWhere(['like', 'personal_details.address_of_spouse', $this->address_of_spouse])
            ->andFilterWhere(['like', 'personal_details.spouse_telephone', $this->spouse_telephone])
            ->andFilterWhere(['like', 'personal_details.name_of_banker', $this->name_of_banker])
            ->andFilterWhere(['like', 'personal_details.name_of_PFA', $this->name_of_PFA])
            ->andFilterWhere(['like', 'personal_details.name_of_PFC', $this->name_of_PFC])
            ->andFilterWhere(['like', 'employment_details.client', $this->client])
            ->andFilterWhere(['like', 'employment_details.location', $this->unit])
            ->andFilterWhere(['like', 'personal_details.RSA_number', $this->RSA_number]);
            // ->andFilterWhere(['like', 'employment_details.employment_type', $this->etype]);
            // ->andFilterWhere(['like', 'employment_details.employment_type', $this->etype]);

        return $dataProvider;
    }
}
