<?php
use backend\models\User;
use frontend\models\Instruments;
use backend\models\Workflow;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker; use yii\helpers\ArrayHelper; use backend\models\TaskType;
?>
<h1>All Transactions</h1>

<div>

<?php $form = ActiveForm::begin(['action'=>Yii::$app->UrlManager->createUrl(['requisitions/allrequisitions'])]); ?>

<div class="well well-sm">
<?php
echo '<label class="control-label">From</label>';
echo DatePicker::widget([
    'name' => 'from',
    'id' => 'from',
    'options' => ['autocomplete'=>'Off'],
    //'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,
       
    ]
]); ?>

</div>

<div class="well well-sm">
<?php
echo '<label class="control-label">To</label>';
echo DatePicker::widget([
    'name' => 'to',
    'id' => 'to',
    'options' => ['autocomplete'=>'Off'],
   // 'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,

    ]
]); ?>

</div>
<div class="well well-sm">
 <?= Html::textInput('tid',null,['class'=>'form-control','placeholder'=>'Enter Transaction ID','id'=>'tid','autocomplete'=>'off']) ?>
</div>

<div class="form-group">
<?= Html::dropDownList('status', null,
      ['1'=>'Concluded','2'=>'Rejected','3'=>'Not Concluded'],['class'=>'form-control','prompt'=>'']) ?>
</div>

<div class="form-group">
<?= Html::dropDownList('task_type', null,
      ArrayHelper::map(TaskType::find()->all(), 'id', 'resource_type'),['class'=>'form-control','prompt'=>'']) ?>
</div>

<div class="form-group">
        <?= Html::submitButton('Fetch', ['class' => 'btn btn-success','name'=>'sent']) ?>
    </div>

    <?php ActiveForm::end(); ?>

<div>
<table class="table table-bordered table-striped">

<tr style="font-weight:bold; text-transform-uppercase;">

<td>Transaction Type</td>
<td>Raised By</td>
<td>Initiating Document</td>
<td>Status</td>
<td>Rejected?</td>
<td>Present Position</td>
<td>Created On</td>
<td>Updated On</td>

</tr>

<?php
$dins='';
$uin=0;
foreach($requisitions as $req)
{ $work=Workflow::findOne($req->workflow_id)->instrument;  $ins=explode(',', $work); $uin=$ins[0]; $dins=Instruments::findOne($uin)->instrument_name; //}else{ $ins=$work; $uin=$ins;  $dins=Instruments::findOne($uin)->instrument_name; }
	?>

<tr>
<td><?= Html::a($req->title,['/requisitions/requisitiondetails','tid'=>$req->transaction_id,'doc'=>$uin]) ?></td>
<td><?= ucwords(User::getName($req->raised_by)) ?></td>
<td><?= $dins ?></td>
<td><?= $req->concluded==1 ? 'Concluded' : 'Not Concluded' ?></td>
<td><?= $req->rejected==1 ? 'Rejected' : 'Not Rejected' ?></td>
<td><?php $use=User::findOne($req->status); echo ucwords($use->first_name." ".$use->last_name) ?></td>
<td><?= isset($req->created_at) ? date('jS F Y',strtotime($req->created_at)) : '' ?></td>
<td><?= isset($req->updated_at) ? date('jS F Y',strtotime($req->updated_at)) : 'Not Updated' ?></td>
</tr>

	<?php
}

?>
</table>

</div>