<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker; 
use frontend\models\Charts;
use frontend\models\Vendors;
use frontend\models\Customers;
use frontend\models\Ledger;
?>
<h1>RECEIPTS & PAYMENTS</h1>


<div>

<?php $form = ActiveForm::begin(['action'=>Yii::$app->UrlManager->createUrl(['requisitions/pnld'])]); ?>

<div class="well well-sm">
<?php
echo '<label class="control-label">From</label>';
echo DatePicker::widget([
    'name' => 'from',
    'id' => 'from',
    'options' => ['autocomplete'=>'Off'],
    //'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,
       
    ]
]); ?>

</div>

<div class="well well-sm">
<?php
echo '<label class="control-label">To</label>';
echo DatePicker::widget([
    'name' => 'to',
    'id' => 'to',
    'options' => ['autocomplete'=>'Off'],
   // 'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,
    ]
]); ?>

</div>

<div class="form-group">
        <?= Html::submitButton('Fetch', ['class' => 'btn btn-success','name'=>'sent']) ?>
    </div>

    <?php ActiveForm::end(); ?>

<div>
	<table class="table table-bordered table-striped">
		<tr>
<td colspan="2" style="text-transform:uppercase; font-size:26px; font-weight:bold;">RECEIPTS</td>
		</tr>

	
<?php
if($income_details!=null){
foreach($income_details as $inc)
{
	?>
	<tr>
      
<td><?php // echo Charts::findOne($inc['chart_account'])->title ?>
<?php $use=Ledger::find()->where(['id'=>$inc['lid'],'cid'=>Yii::$app->user->identity->cid])->one()->tlink; echo Charts::findOne(Ledger::find()->where(['transaction_id'=>$use,'cid'=>Yii::$app->user->identity->cid])->one()->chart_account2)->title; ?>

</td>
<td><del>N</del> <?= number_format($inc['amount'],2) ?></td>
  <td>
<?= date('jS F Y',strtotime($inc['created_at'])) ?>
        </td>
	</tr>

	<?php
}
}
?>

<tr style="font-weight:bold;">
<td>TOTAL RECEIPTS</td><td style="border-bottom:3px solid #000;"><?= number_format($total_income,2) ?></td>
</tr>


	<tr>
<td colspan="2" style="text-transform:uppercase; font-size:26px; font-weight:bold;">PAYMENTS</td>
		</tr>

	
<?php
if($expenditure!=null || $income!=null){

    ?>

    <div style="font-weight:bold; font-size:18px;">
Receipts & Payments from <?= date('jS F Y',strtotime($from)) ?> to <?= date('jS F Y',strtotime($to)) ?>
</div>

<?php
foreach($expenditure as $exp)
{
	?>
	<tr>
        
<td>
    <?=  Charts::findOne(Ledger::find()->where(['transaction_id'=>$exp['tlink']])->one()->chart_account)->title ?>
</td>
<td><del>N</del> <?= number_format($exp['amount_paid'],2) ?></td>
<td><?= date('jS F Y',strtotime($exp['created_at'])) ?></td>
	</tr>

	<?php
}}
?>

<tr style="font-weight:bold;">
<td>TOTAL PAYMENTS</td><td style="border-bottom:3px solid #000;"><?= number_format($total_exp,2) ?></td>
</tr>

<tr>
<?php if($total_income>$total_exp){ ?>
<td style="text-transform:uppercase; font-size:26px; font-weight:bold;">Total net Profit</td>
<td style="text-transform:uppercase; font-size:18px; font-weight:bold;"><del>N</del> <?= number_format($total_income-$total_exp,2) ?></td>
<?php } ?>

<?php if($total_exp>$total_income){ ?>
<td style="text-transform:uppercase; font-size:26px; font-weight:bold;">Total Loss</td>
<td style="text-transform:uppercase; font-size:18px; font-weight:bold;"><del>N</del> <?= number_format($total_exp-$total_income,2) ?></td>
<?php } ?>
</tr>
</table>
</div>

</div>