<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;
use frontend\models\Customers;
use backend\models\Shops;
use frontend\models\Banks;
use yii\helpers\ArrayHelper;
use backend\models\User;

?>
<h1>Sales Report</h1>


<div>

<?php $form = ActiveForm::begin(['action'=>Yii::$app->UrlManager->createUrl(['sales/sales_report'])]); ?>

<div class="well well-sm">
<?php
echo '<label class="control-label">From</label>';
echo DatePicker::widget([
    'name' => 'from',
    'id' => 'from',
    'options' => ['autocomplete'=>'Off'],
    //'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,
       
    ]
]); ?>

</div>

<div class="well well-sm">
<?php
echo '<label class="control-label">To</label>';
echo DatePicker::widget([
    'name' => 'to',
    'id' => 'to',
    'options' => ['autocomplete'=>'Off'],
   // 'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,
    ]
]); ?>

</div>
<?php if(Yii::$app->user->identity->role=='Client Admin' || Yii::$app->user->identity->role=='accounts') { ?>
<div class="well well-sm">
 <?= Html::dropDownList('staff',null, ArrayHelper::map(User::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['department'=>1])->andWhere(['place'=>2])->all(),'id','names'),['class'=>'form-control','prompt'=>'Select Sales Agent','id'=>'user']) ?>
</div>

<div class="well well-sm">
 <?= Html::dropDownList('shop',null, ArrayHelper::map(Shops::find()->where(['cid'=>Yii::$app->user->identity->cid])->all(),'id','name'),['class'=>'form-control','prompt'=>'Select Sales Point','id'=>'shop']) ?>
</div>

<div class="well well-sm">
 <?= Html::dropDownList('bank',null, ArrayHelper::map(Banks::find()->where(['cid'=>Yii::$app->user->identity->cid])->all(),'bid','bank'),['class'=>'form-control','prompt'=>'Select Bank','id'=>'bank']) ?>
</div>

<?php } ?>


<div class="form-group">
        <?= Html::submitButton('Fetch', ['class' => 'btn btn-success','name'=>'sent']) ?>
    </div>

    <?php ActiveForm::end(); ?>


</div>

<div id="holder">
<?php

if($model!=null)
{
    // var_dump($model);
    echo "<h4>Sales Report for period from ". date('jS F Y',strtotime($from)).' to '.date('jS F Y',strtotime($to))." [".Shops::findOne($shop)->name."] [".Banks::findOne($bank)->bank."] [".User::findOne($staff)->last_name."]</h4>";

?>
<table class="table table-bordered table-striped">
<tr style="text-transform:uppercase">
<td>Client</td>
<td>Amount (<del>N</del> )</td>
<td>Bank</td>
<td>shop ID </td>
<td>Transaction ID</td>
<td>Details</td>
<td></td>
</tr>
<?php
$tot=0;
foreach($model as $mod)
{

    // $load=json_decode($mod['requested_item'],true);
    // // var_dump($load[0]);
    // foreach($load as $lo)
    // {
    //     $tot+=$lo['total'];

    $tot+=$mod['amount_paid'];
  
    if(isset($mod['tlink']) && $mod['tlink']!="" && !empty($mod['tlink']) && $mod['tlink']!=0)
    {
        $cab=$mod['tlink'];
    }elseif(isset($mod['leg2_link']) && $mod['leg2_link']!="" && !empty($mod['leg2_link']) && $mod['leg2_link']!=0){
        $cab=$mod['leg2_link'];
    }
?>

<tr style="">
<td><?= isset($mod['vendor']) ? ucwords(Customers::findOne($mod['vendor'])->name) : ''?></td>
<td><?= number_format($mod['amount_paid'],2) ?></td>
<td><?= isset($mod['bank']) ? ucwords(Banks::findOne($mod['bank'])->bank) : '' ?></td>
<td><?= isset($mod['shop_id']) ? ucwords(Shops::findOne($mod['shop_id'])->name) : '' ?></td>
<td><?= ucwords($mod['transaction_id']) ?></td>
<td><?= isset($cab) ? Html::button('Details',['onclick'=>'details('.$cab.')','class'=>'btn btn-primary form-control', 'style'=>'']) : '' ?></td>
<td><?= date('jS F Y H:i:s A',strtotime($mod['created_at'])) ?></td>
</tr>

<?php
}
// }
?>
<tr style="font-weight:bold; text-transform:uppercase;">

<td >TOTAL sales</td>
<td><del>N</del> <?= number_format($tot,2)  ?></td>
<td></td>
<td colspan="3"></td>
<td></td>
</tr>
<?php
}
?>

</table>
</div>

    <div style="margin-top:20px;">
    
<?= Html::button('Print Document',['class'=>'btn btn-primary','onclick'=>'print()','style'=>'']) ?>

    </div>