<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;
use frontend\models\Units;
use yii\helpers\ArrayHelper;

/* @var $this yii\web\View */
/* @var $model frontend\models\Stores */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="stores-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'cid')->hiddenInput(['value'=>Yii::$app->user->identity->cid])->label(false) ?>

    <?= $form->field($model, 'name')->textInput(['rows' => 6]) ?>

      <?= $form->field($model, 'quantity')->textInput() ?>
      <?= $form->field($model, 'cost_price')->textInput() ?>

      <?= Html::activeDropDownList($model,'units', ArrayHelper::map(Units::find()->all(),'id','unit_name'),['class'=>'form-control','prompt'=>'Select Measurment Unit','id'=>'units']) ?>

    <?= $form->field($model, 'particulars')->textarea(['rows' => 6]) ?>
    

  <?php echo $form->field($model, 'countable')->dropDownList(
    [1=>'Deductable',2=>'Non-deductable'],['prompt'=>'']) ?>



<?= $form->field($model, 'received_date')->widget(DatePicker::classname(), [
    'options' => ['placeholder' => 'Received Date ...','autocomplete'=>'Off'],
    'pluginOptions' => [
        'autoclose'=>true,
         'format' => 'yyyy-mm-dd',
         'todayHighlight' => true,
    ]
]); ?>



  

    <?= $form->field($model, 'recieved_by')->hiddenInput(['value'=>Yii::$app->user->identity->id])->label(false) ?>

   



   

  

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
