<?php
use frontend\models\Units;
use yii\helpers\Html;
?>
<h1>Store Ledger</h1>

<div id="holder">

<table class="table table-bordered table-striped">

	<tr style="font-weight:bold;">
 		<td>Date</td>
 		<td>Item Name</td>
 		<td>Particulars</td>
 		<td>Stock</td>
 		<td>Measurement</td>
 		<td></td>
 		
 		
	</tr>

	<?php foreach($records as $rec)
	{
		?>
			<tr>

 			<td><?= date('jS F Y',strtotime($rec->received_date)) ?></td>
 		
 			<td><?= Html::a($rec->name,['/stores/itemdetails','id'=>$rec->id],['class'=>'', 'style'=>'display:block;']) ?></td>
 			<td><?= ucfirst($rec->particulars) ?></td>
 			<td><?= $rec->quantity ?></td>
 			<td><?= Units::findOne($rec->units)->unit_name; ?></td>
 			<td><?= Html::button('Adjust',['onclick'=>'adjust('.$rec->id.',"'.ucwords($rec->name).'")','class'=>'btn btn-primary form-control','style'=>'display:block; margin-bottom:5px;']) ?></td> 				
 			
 			
 			

			</tr>

		<?php
	}

?>


</table>

</div>

<div>
<?= Html::button('Print Document',['class'=>'btn btn-primary','onclick'=>'print()','style'=>'']) ?>
</div>

<div id="myModalAdj" class="modal fade" role="dialog" data-backdrop="static" data-keyboard="false">
  <div class="modal-dialog">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
              </div>
      <div class="modal-body" style="text-align:center;">
       Request  Stock Ajustment for <span id="aname" style="font-weight:bold;"></span><br>
       <?= Html::hiddenInput('iid','',['id'=>'adid']) ?>
       <?= Html::hiddenInput('manager',2,['id'=>'manager','placeholder'=>'','class'=>'form-control']) ?>
       <?= Html::textInput('quantity','',['id'=>'quantity','placeholder'=>'Enter Adjustment Quantity','class'=>'form-control','autocomplete'=>'Off']) ?>
       <?= Html::dropDownList('dirrection',null, [1=>'Increase',2=>'Decrease'],['class'=>'form-control','prompt'=>'','id'=>'direction','onchange'=>'']) ?>
       <?= Html::button('Send Request',['onclick'=>'do_adjust()','class'=>'btn btn-primary','style'=>'display:block; margin:auto; margin-top:20px;']) ?>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
    </div>

  </div>
</div>