<?php

use yii\helpers\Html;
use yii\grid\GridView;

use backend\models\User;
use backend\models\Departments;

/* @var $this yii\web\View */
/* @var $searchModel backend\models\SearchAuthorizers */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Authorizers';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="authorizers-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a('Create Authorizers', ['create','id'=>$id], ['class' => 'btn btn-success']) ?>
    </p>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'id',
            'department',  
             ['label'=>'Department', 'format'=>'raw', 'attribute'=>'department', 'value'=>function ($model){  return ucwords(Departments::findOne($model->department)->department_name); }],           
            ['label'=>'Authorizer', 'format'=>'raw', 'attribute'=>'authorizer', 'value'=>function ($model){  return ucwords(User::findOne($model->authorizer)->first_name); }], 

            'cid',

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
</div>
