<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;

use kartik\date\DatePicker;
use frontend\models\Requisitions;
use yii\helpers\ArrayHelper;
use backend\models\TaskType;

use backend\models\Departments;
use backend\models\User;
use backend\models\Workflow;
?>


<?php
if(empty(Yii::$app->request->get('id')) && empty(Yii::$app->request->post('id'))){
	die('Please select a client for this action '.Html::a('Go to Clients List',['/clients/index']));
}
?>

<h1>Requisitions Report</h1>

<div>
<?php $form = ActiveForm::begin(['action'=>Yii::$app->UrlManager->createUrl(['clients/reports'])]); ?>

<div class="well well-sm">
<?php
echo '<label class="control-label">From</label>';
echo DatePicker::widget([
    'name' => 'from',
    'id' => 'from',
    //'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
       
    ]
]); ?>

</div>

<div class="well well-sm">
<?php
echo '<label class="control-label">To</label>';
echo DatePicker::widget([
    'name' => 'to',
    'id' => 'to',
   // 'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd'
    ]
]); ?>

</div>

<div class="form-group">
<div style="display:inline-block;">
 <?= Html::dropDownList('tasktype',null, ArrayHelper::map(TaskType::find()->all(),'id','resource_type'),['class'=>'form-control','prompt'=>'Task Type','id'=>'']) ?>
</div>

<div style="display:inline-block;">
 <?= Html::dropDownList('concluded',null, ['not_concluded'=>'Not Concluded','concluded'=>'Concluded'],['class'=>'form-control','prompt'=>'Is Concluded','id'=>'']) ?>
</div>

<div style="display:inline-block;">
 <?= Html::dropDownList('rejected',null, ['not_rejected'=>'Not Rejected','rejected'=>'Rejected'],['class'=>'form-control','prompt'=>'Is Rejected','id'=>'']) ?>
</div>

<div style="display:inline-block;">
 <?= Html::dropDownList('department',null, ArrayHelper::map(Departments::find()->all(),'id','department_name'),['class'=>'form-control','prompt'=>'Department','id'=>'']) ?>
</div>

<div style="display:inline-block;">
 <?= Html::dropDownList('raised_by',null, ArrayHelper::map(User::find()->all(),'id','Names'),['class'=>'form-control','prompt'=>'Originator','id'=>'']) ?>
</div>

<div>
<?= Html::hiddenInput('id',$id,[]) ?>
</div>
</div>




    <div class="form-group">
        <?= Html::submitButton('Fetch', ['class' => 'btn btn-success','name'=>'sent']) ?>
    </div>

    <?php ActiveForm::end(); ?>
</div>


<div>
<table class="table table-bordered table-striped">

<tr style="font-weight:bold; text-transform:uppercase;">
<td>Title</td>
<td>Originating Department</td>
<td>Raised By</td>
<td>Is Concluded</td>

<td>Is Rejected</td>
<td>Location</td>
<td>Task Type</td>
<td>Total Amount</td>
<td>Created at</td>
<td>Updated at</td>
</tr>


<?php
if($results!=null)
{
	echo $string;
	$b=0;
	foreach($results as $res)
	{
		$work=Workflow::findOne($res['workflow_id'])->instrument;  $ins=explode(',', $work); $uin=$ins[0]; //$dins=Instruments::findOne($uin)->instrument_name; //}else{ $ins=$work; $uin=$ins;  $dins=Instruments::findOne($uin)->instrument_name; }
		$am=json_decode($res['requested_item'],true);   $totalit+=$am[$b]['total'];
		?>
<tr style="">

<td><?= Html::a($res['title'],['/requisitions/requisitiondetails','tid'=>$res['transaction_id'],'doc'=>$uin]) ?></td>
<td><?= Departments::getDep($res['originating_department']) ?></td>
<td><?= isset($res['raised_by']) ? User::getName($res['raised_by']) : 'Not set' ?></td>
<td><?= isset($res['concluded']) ? $res['concluded']==1 ? 'Concluded' : 'Not Concluded' : 'Not Concluded' ?></td>

<td><?= isset($res['rejected']) ? $res['rejected']==1 ? 'Rejected' : 'Not Rejected' : 'Not Set' ?></td>
<td><?= User::getName($res['status']) ?></td>
<td><?= TaskType::getTT($res['task_type']) ?></td>
<td><del>N</del> <?= number_format($am[$b]['total'],2) ?></td>
<td><?= date('jS F Y',strtotime($res['created_at'])) ?></td>
<td><?= isset($res['updated_at']) ? date('jS F Y',strtotime($res['updated_at'])) : '' ?></td>
</tr>


		<?php
		
	}
	$b++;
}

?>
<tr style="font-weight:bold;">
<td colspan="6"></td>
<td>Total</td>
<td><del>N</del> <?= number_format($totalit,2) ?></td>
<td></td>
<td></td>
</tr>
</table>
</div>