<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use backend\models\Industries;

/* @var $this yii\web\View */
/* @var $model backend\models\Clients */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Clients', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="clients-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
          //  'id',
            'client_name:ntext',
            'client_address:ntext',            
             ['label'=>'Industry', 'format'=>'raw', 'value'=>Industries::findOne($model->industry)->name],
              //['label'=>'Create Task', 'format'=>'raw', 'value'=>Yii::$app->urlManager->createUrl('/task/create)',['class'=>'btn btn-primary'])],
           //['label'=>'Create Task', 'format'=>'raw', 'value'=>'<a class="btn btn-primary" href="'.Url::toRoute("/task/create",["id"=>$model->id]).'">Create Task</a>'],
            ['label'=>'View Tasks', 'format'=>'raw', 'value'=>Html::a('View Tasks',['/task/viewtasks','id'=>$model->id],['class'=>'btn btn-primary'])],
            ['label'=>'Users', 'format'=>'raw', 'value'=>Html::a('View Users',['/clients/viewusers','id'=>$model->id],['class'=>'btn btn-primary'])],            
           //['label'=>'Departments', 'format'=>'raw', 'value'=>Html::a('Departments',['/departments/index','id'=>$model->id],['class'=>'btn btn-primary'])],
           // ['label'=>'Department Authorizers', 'format'=>'raw', 'value'=>Html::a('Department Authorizers',['/authorizers/index','id'=>$model->id],['class'=>'btn btn-primary'])],
           // ['label'=>'Designations', 'format'=>'raw', 'value'=>Html::a('Designations',['/designation/create','id'=>$model->id],['class'=>'btn btn-primary'])],
            ['label'=>'Requisition Reports', 'format'=>'raw', 'value'=>Html::a('Requisition Reports',['/clients/reports','id'=>$model->id],['class'=>'btn btn-primary'])],
            ['label'=>'Store Ledger', 'format'=>'raw', 'value'=>Html::a('Store Ledger',['/clients/sledger','id'=>$model->id],['class'=>'btn btn-primary'])],
            ['label'=>'Cash Book', 'format'=>'raw', 'value'=>Html::a('Cash Book',['/clients/cashbook','id'=>$model->id],['class'=>'btn btn-primary'])],
            ['label'=>'Bill of Quantity', 'format'=>'raw', 'value'=>Html::a('Bill Of Quantity',['/boq/list','id'=>$model->id],['class'=>'btn btn-primary'])],
    // when we get       
       
          //  'created_at',
          //  'updated_at',
            'phone',
            'email:email',
            'website',
        ],
    ]) ?>

</div>
