<?php
use yii\helpers\Html;
use backend\models\Designation;
use backend\models\Departments;
use backend\models\Clients;

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Clients', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

?>
<H3>View Users for <?php echo ucwords(Clients::findOne($id)->client_name); ?></H3>
<div>
<?= Html::a('Add User',['/site/clientsignup','id'=>$id],['class'=>'btn btn-primary']) ?>
</div>

<table class="table table-bordered table-striped">
	<tr style="font-weight:bold;">
<td>Staff Name</td><td>Username</td><td>Workgroup</td><td>Group Position</td> <td>Client Role</td> <td>Action</td><td>Action</td>
	</tr>
	<?php foreach($users as $user)
	{
		?>

<tr>
<td><?= ucwords($user->first_name.' '.$user->last_name) ?></td>
<td><?= ucwords($user->username) ?></td>
<td><?= Departments::findOne($user->department)->department_name ?></td>
<td><?= !empty($user->place) ? ($user->place==1 ? 'Group Head' : 'Group Member') : 'Not Set'   ?></td>
<td><?= $user->role ?></td>
<td> <?= Html::a('Edit User',['/user/update','id'=>$user->id,'cid'=>$id],['class'=>'btn btn-primary']) ?></td>
<td></td>
</tr>


		<?php
	}

?>


</table>
<?php



?>