<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use backend\models\Clients;
use backend\models\User;

/* @var $this yii\web\View */
/* @var $model backend\models\Departments */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Workgroup', 'url' => ['index','id'=>$id=Yii::$app->request->get('cid') ]];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="departments-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            ['label'=>'Client', 'format'=>'raw', 'value'=>ucwords(Clients::findOne($model->cid)->client_name)],       
            'department_name',
             // ['label'=>'Authorizer', 'format'=>'raw', 'value'=>ucwords(User::findOne($model->authorizer)->username)],
            'created_at',
            'updated_at',
        ],
    ]) ?>

</div>
