<?php

/* @var $this yii\web\View */
/* @var $form yii\bootstrap\ActiveForm */
/* @var $model \frontend\models\SignupForm */

use yii\helpers\Html;
use yii\bootstrap\ActiveForm;
use backend\models\Designation;
use backend\models\Departments;
use backend\models\Place;
use yii\helpers\ArrayHelper;
use mdm\admin\models\AuthItem;


$this->title = 'Create User for '.ucwords($name);
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="site-signup">
    <h1><?= Html::encode($this->title) ?></h1>

    <p>Please fill out the following fields to signup:</p>

    <div class="row">
        <div class="col-lg-5">
            <?php $form = ActiveForm::begin(['id' => 'form-signup']); ?>

                <?= $form->field($model, 'username')->textInput(['autofocus' => true]) ?>

                <?= $form->field($model, 'cid')->hiddenInput(['value'=>$client_id])->label(false) ?>

                <?= $form->field($model, 'first_name')->textInput() ?>

                <?= $form->field($model, 'last_name')->textInput() ?>
                <?php 
            //     $current_user_roles = Yii::$app->authManager->getRolesByUser(Yii::$app->user->id);
                $available_roles = Yii::$app->authManager->getRoles();
                $forbidden_roles=array('adminRole');
            //     foreach($available_roles as $role){
            //     if(in_array($role,$forbidden_roles)){
            //         $index = array_search($role,$available_roles);
            //         \yii\helpers\ArrayHelper::remove($available_roles,$index);
            //     }
            // }  
            unset($available_roles['adminRole']);           
                // var_dump($available_roles); //die;
                
                 ?>
                <?php $items=ArrayHelper::map($available_roles, 'name','name'); ?>
                <?= $form->field($model, 'role')->dropDownList($items,['prompt'=>'']) ?>

                <?= $form->field($model, 'email') ?>




                  <?php echo $form->field($model, 'department')->dropDownList(
    ArrayHelper::map(Departments::find()->all(),'id','department_name'),['prompt'=>''])->label('Workgroup') ?>

     <?php echo $form->field($model, 'place')->dropDownList(
    ArrayHelper::map(Place::find()->all(),'id','name'),['prompt'=>'']) ?>

     

                <?= $form->field($model, 'password')->passwordInput() ?>

                <div class="form-group">
                    <?= Html::submitButton('Create User', ['class' => 'btn btn-primary', 'name' => 'signup-button']) ?>
                </div>

            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>
