<?php

/* @var $this yii\web\View */
/* @var $form yii\bootstrap\ActiveForm */
/* @var $model \frontend\models\SignupForm */

use yii\helpers\Html;
use yii\bootstrap\ActiveForm;
use backend\models\Designation;
use backend\models\Departments;
use yii\helpers\ArrayHelper;
use mdm\admin\models\AuthItem;


$this->title = 'Create User for '.ucwords($name);
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="site-signup">
    <h1><?= Html::encode($this->title) ?></h1>

    <p>Please fill out the following fields to signup:</p>

    <div class="row">
        <div class="col-lg-5">
            <?php $form = ActiveForm::begin(['id' => 'form-signup']); ?>

                <?= $form->field($model, 'username')->textInput(['autofocus' => true]) ?>

                <?= $form->field($model, 'cid')->hiddenInput(['value'=>$client_id])->label(false) ?>

                <?= $form->field($model, 'first_name')->textInput() ?>

                <?= $form->field($model, 'last_name')->textInput() ?>
                
                <?php $items=ArrayHelper::map(Yii::$app->authManager->getRoles(), 'name','name'); ?>
                <?= $form->field($model, 'role')->dropDownList($items,['prompt'=>'']) ?>

                <?= $form->field($model, 'email') ?>

      <?php echo $form->field($model, 'position')->dropDownList(
    ArrayHelper::map(Designation::find()->all(),'id','position'),['prompt'=>'','onchange'=>'set_label()','id'=>'position']) ?>


      <?= $form->field($model, 'position_label')->hiddenInput(['value'=>$model->position_label,'id'=>'p_label','readonly'=>true])->label(false) ?>


      <?php echo $form->field($model, 'department')->dropDownList(
    ArrayHelper::map(Departments::find()->where(['cid'=>$client_id])->all(),'id','department_name'),['prompt'=>'']) ?>



                <?= $form->field($model, 'password')->passwordInput() ?>

                <div class="form-group">
                    <?= Html::submitButton('Create User', ['class' => 'btn btn-primary', 'name' => 'signup-button']) ?>
                </div>

            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>
