<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use backend\models\User;
use backend\models\Clients;
use backend\models\Departments;

/* @var $this yii\web\View */
/* @var $model backend\models\Tasks */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Tasks', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="tasks-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
             ['label'=>'Client', 'format'=>'raw', 'value'=>ucwords(Clients::findOne($model->cid)->client_name)],            
            ['label'=>'Initiating Department', 'format'=>'raw', 'value'=>ucwords(Departments::findOne($model->initiator)->department_name)],
            ['label'=>'Finisher', 'format'=>'raw', 'value'=>ucwords(User::findOne($model->finisher)->Names)],
            'task_name:ntext',
            // 'created_at',
            // 'updated_at',
        ],
    ]) ?>

</div>
