<?php

namespace backend\models;


use Yii;

/**
 * This is the model class for table "departments".
 *
 * @property int $id
 * @property int $cid
 * @property string $department_name
 * @property int $authorizer
 * @property string $created_at
 * @property string $updated_at
 */
class Departments extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return 'departments';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['cid', 'department_name'], 'required'],
            [['cid'], 'integer'],
            [['created_at', 'updated_at'], 'safe'],
            [['department_name'], 'string', 'max' => 250],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'department_name' => 'Workgroup Name',
            // 'authorizer' => 'Authorizer',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }

    function getDep($id)
    {
        $name=Departments::findOne($id);
        return ucwords($name->department_name);
    }
}
