<?php
namespace backend\models;

use yii\base\Model;
use common\models\Admin;

/**
 * Signup form
 */
class SignupForm extends Model
{
    public $username;
    public $email;
    public $password;
    public $first_name;
    public $last_name;
    


    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            ['username', 'trim'],
            ['username', 'required'],
            ['username', 'unique', 'targetClass' => '\common\models\Admin', 'message' => 'This username has already been taken.'],
            ['username', 'string', 'min' => 2, 'max' => 255],

            ['first_name','trim'],
            ['first_name', 'required'],

            // ['role','required'],
            // ['role', 'string', 'min' =>2, 'max'=>200],

            ['last_name','trim'],
            ['last_name', 'required'],

            ['email', 'trim'],
            ['email', 'required'],
            ['email', 'email'],
            ['email', 'string', 'max' => 255],
            ['email', 'unique', 'targetClass' => '\common\models\Admin', 'message' => 'This email address has already been taken.'],

            ['password', 'required'],
            ['password', 'string', 'min' => 6],
        ];
    }

    /**
     * Signs user up.
     *
     * @return User|null the saved model or null if saving fails
     */
    public function signup()
    {
        if (!$this->validate()) {
            return null;
        }
        
      //  if ($this->validate()) {
        $user = new Admin();
        $user->username = $this->username;
        $user->email = $this->email;
        $user->first_name=$this->first_name;
        $user->last_name=$this->last_name;
        $user->setPassword($this->password);
        // $user->role=$this->role;
        $user->generateAuthKey();

       
        
        return $user->save() ? $user : null;
  //  }
        // return $this->redirect(['site/index']);
    }
}
