<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "transfers".
 *
 * @property int $id
 * @property int $cid
 * @property int $sender_id person sending or releasing items, good or materials to another
 * @property int $reciever_id person receiving or requesting items or goods from another
 * @property int $item_id
 * @property string $item_name
 * @property int $quantity
 * @property int $units
 * @property string $created_at
 * @property string $updated_at
 */
class Transfers extends \yii\db\ActiveRecord implements \yz\shoppingcart\CartPositionInterface
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'transfers';
    }

     use  \yz\shoppingcart\CartPositionTrait;
    public function getPrice()
    {
        return $this->price;
    }

    public function getId()
    {
        return $this->id;
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cid', 'sender_id', 'reciever_id', 'item_id', 'item_name', 'quantity', 'units'], 'required'],
            [['cid', 'sender_id', 'reciever_id', 'item_id', 'quantity', 'units'], 'integer'],
            [['created_at', 'updated_at'], 'safe'],
            [['item_name'], 'string', 'max' => 200],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'sender_id' => 'Sender ID',
            'reciever_id' => 'Reciever ID',
            'item_id' => 'Item ID',
            'item_name' => 'Item Name',
            'quantity' => 'Quantity',
            'units' => 'Units',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }
}
