<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "transfers_history".
 *
 * @property int $id
 * @property int $cid
 * @property int $sender_id person sending or releasing items, good or materials to another
 * @property int $reciever_id person receiving or requesting items or goods from another
 * @property int $item_id
 * @property string $item_name
 * @property int $quantity 
 * @property string $created_at
 * @property string $updated_at
 */
class TransfersHistory extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'transfers_history';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cid', 'sender_id', 'reciever_id', 'item_id', 'item_name', 'quantity'], 'required'],
            [['cid', 'sender_id', 'reciever_id', 'item_id', 'quantity'], 'integer'],
            [['created_at', 'updated_at'], 'safe'],
            [['item_name'], 'string', 'max' => 200],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'cid' => 'Cid',
            'sender_id' => 'Sender ID',
            'reciever_id' => 'Reciever ID',
            'item_id' => 'Item ID',
            'item_name' => 'Item Name',
            'quantity' => 'Quantity',            
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }
}
