<?php

namespace backend\models;

use Yii;

/**
 * This is the model class for table "user".
 *
 * @property int $id
 * @property string $username
 * @property string $first_name
 * @property string $last_name
 * @property string $role
 * @property int $department
 * @property int $cid
 * @property string $email
 * @property int $position
 * @property string $position_label
 * @property int $status
 * @property string $auth_key
 * @property string $password_hash
 * @property string $password_reset_token
 * @property int $created_at
 * @property int $updated_at
 * @property int $place
 */
class User extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'user';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['username', 'first_name', 'last_name', 'role', 'cid', 'email', 'department', 'auth_key', 'password_hash'], 'required'],
            [['cid', 'department', 'status', 'created_at', 'updated_at','place'], 'integer'],
            [['username', 'email', 'password_hash', 'password_reset_token'], 'string', 'max' => 255],
            [['first_name', 'last_name'], 'string', 'max' => 150],
            [['role'], 'string', 'max' => 200],
            // [['position_label'], 'string', 'max' => 225],
            [['auth_key'], 'string', 'max' => 32],
            [['username'], 'unique'],
            [['email'], 'unique'],
            [['place'], 'required'],
            [['password_reset_token'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'username' => 'Username',
            'first_name' => 'First Name',
            'last_name' => 'Last Name',
            'role' => 'Role',
           'department' => 'Workgroup',
            'cid' => 'Cid',
            'email' => 'Email',
          //  'position' => 'Position',
          //  'position_label' => 'Position Label',
            'status' => 'Status',
            'place' => 'Place',
            'auth_key' => 'Auth Key',
            'password_hash' => 'Password Hash',
            'password_reset_token' => 'Password Reset Token',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }

     static function getName($id)
    {
        $name=User::findOne($id);
        return ucwords($name->last_name.' '.$name->first_name);
    }

    function getNames()
    {       
        return $this->last_name.' '.$this->first_name;
    }

    function getLabel()
    {
        return ucwords($this->position_label).' - ('.ucwords($this->last_name.' '.$this->first_name).')';
    }

    function getLabel2()
    {
        return ucwords($this->last_name.' '.$this->first_name).' - ('.ucwords($this->position_label).')';
    }
}
