<?php
use yii\helpers\Html;
use yii\bootstrap\Nav;
use yii\bootstrap\NavBar;
use yii\widgets\Breadcrumbs;
use frontend\assets\AppAsset;
use common\widgets\Alert;
use backend\models\Tasks;
use frontend\models\Requisitions;
use backend\models\RequisitionTypes;
use yii\helpers\Url;
use frontend\models\Ledger;
use frontend\models\Notifications;
use kartik\sidenav\SideNav;
?>
<?php $this->beginContent('@app/views/layouts/main.php'); ?>
        <div class="container">
            
            <div class="col-sm-3">
               <?=
            SideNav::widget([
    'type' => $type,
    'encodeLabels' => false,
    'heading' => $heading,
    'items' => [
        // Important: you need to specify url as 'controller/action',
        // not just as 'controller' even if default action is used.
        //
        // NOTE: The variable `$item` is specific to this demo page that determines
        // which menu item will be activated. You need to accordingly define and pass
        // such variables to your view object to handle such logic in your application
        // (to determine the active status).
        //
        ['label' => 'Dashboard', 'icon' => 'home', 'url' => Url::to(['/site/dashboard', 'type'=>$type]), 'active' => ($item == 'home')],
        // ['label' => 'Tasks', 'icon' => 'book', 'items' => [
        //     ['label' => '<span class="pull-right badge"></span> Inflow', 'url' => Url::to(['/sales/store', 'type'=>$type]), 'active' => ($item == 'store')],
        //     ['label' => '<span class="pull-right badge"></span> Outflow', 'url' => Url::to(['/requisitions/create', 'type'=>$type]), 'active' => ($item == 'create')],
            
        // ]],       
          
        ['label' => '<span class="pull-right badge" id="note_sum"></span> Notifications', 'icon' => 'bullhorn', 'items' => [
            ['label' => 'Attention Required <span class="badge" id="atten"></span>', 'url' => Url::to(['/requisitions/attentionrequired', 'type'=>$type]), 'active' => ($item == 'attentionrequired')],
            ['label' => 'Rejections <span class="badge" id="rej"></span>', 'url' => Url::to(['/requisitions/allrejections', 'type'=>$type]), 'active' => ($item == 'allrejections')],
            ['label' => 'Action Notifications <span class="badge" id="note_count"></span>', 'url' => Url::to(['/requisitions/allnotifications', 'type'=>$type]), 'active' => ($item == 'allnotifications')],
            ['label' => 'Messages <span class="badge" id="mess4"></span>', 'url' => Url::to(['/site/sendm2', 'type'=>$type]), 'active' => ($item == 'allnotifications')]
        ]],
        ['label' => 'Reports', 'icon' => 'book', 'items' => [
            ['label' => '<span class="pull-right badge"></span> Transactions Report', 'url' => Url::to(['/reports/rinflow', 'type'=>$type]), 'active' => ($item == 'new-arrivals'), 'visible'=>Yii::$app->user->identity->role=='Client Admin'  ? true : false],
            ['label' => '<span class="pull-right badge"></span> All Transactions', 'url' => Url::to(['/requisitions/allrequisitions', 'type'=>$type]), 'active' => ($item == 'most-popular'),'visible'=>Yii::$app->user->identity->role=='Client Admin'  ? true : false
            ],
            ['label' => '<span class="pull-right badge"></span> My Transactions', 'url' => Url::to(['/requisitions/myrequisitions', 'type'=>$type]), 'active' => ($item == 'most-popular')],
            
           
        ]],
        ['label' => 'Accounts', 'icon' => 'book',  'items' => [
            ['label' => '<span class="pull-right badge"></span> Profit & Loss', 'url' => Url::to(['/requisitions/pnl', 'type'=>$type]), 'active' => ($item == 'new-arrivals')],
            ['label' => '<span class="pull-right badge"></span> CashBook', 'url' => Url::to(['/ledger/cashbookk', 'type'=>$type]), 'active' => ($item == 'most-popular') //,'visible'=>Yii::$app->user->identity->role=='Client Admin'  ? true : false
            ],
             ['label' => '<span class="pull-right badge"></span> Customer Balances', 'url' => Url::to(['/ledger/debtors', 'type'=>$type]), 'active' => ($item == 'most-popular')],
            // ['label' => '<span class="pull-right badge"></span> CashBook 2', 'url' => Url::to(['/ledger/cash', 'type'=>$type]), 'active' => ($item == 'most-popular')],
             ['label' => '<span class="pull-right badge"></span> Sales Report', 'url' => Url::to(['/sales/sales_report', 'type'=>$type]), 'active' => ($item == 'most-popular')],
             ['label' => '<span class="pull-right badge"></span> Vendor Balances', 'url' => Url::to(['/ledger/creditors', 'type'=>$type]), 'active' => ($item == 'most-popular')],
        ['label' => '<span class="pull-right badge"></span> Reverse Transaction', 'url' => Url::to(['/ledger/reverse', 'type'=>$type]), 'active' => ($item == 'most-popular')],
        ['label' => '<span class="pull-right badge"></span> Sales Receipts ', 'url' => Url::to(['/ledger/sales', 'type'=>$type]), 'active' => ($item == 'most-popular')],
           
        ], 'visible'=>Yii::$app->user->identity->role=='Client Admin' || Yii::$app->user->identity->role=='accounts' ? true : false],

        ['label' => 'Store', 'icon' => 'book', 'items' => [
            ['label' => '<span class="pull-right badge"></span> Store Ledger', 'url' => Url::to(['/stores/sledger', 'type'=>$type]), 'active' => ($item == 'new-arrivals')],
             ['label' => '<span class="pull-right badge"></span> Vendors', 'url' => Url::to(['/vendors/index', 'type'=>$type]), 'active' => ($item == 'most-popular')],
             ['label' => '<span class="pull-right badge"></span> Vendor Ledger', 'url' => Url::to(['/vendors/vledger', 'type'=>$type]), 'active' => ($item == 'new-arrivals')],
           
           
        ],'visible'=>Yii::$app->user->identity->role=='Client Admin' || Yii::$app->user->identity->role=='Store Manager'  ? true : false],
       
         ['label' => 'Shop', 'icon' => 'book', 'items' => [
            ['label' => '<span class="pull-right badge"></span> Shop Ledger', 'url' => Url::to(['/inventory/dledger', 'type'=>$type]), 'active' => ($item == 'new-arrivals')],
             ['label' => '<span class="pull-right badge"></span> Customer Details', 'url' => Url::to(['/customers/index', 'type'=>$type]), 'active' => ($item == 'new-arrivals')],
        ['label' => '<span class="pull-right badge"></span> Customer Ledger', 'url' => Url::to(['/customers/cledger', 'type'=>$type]), 'active' => ($item == 'new-arrivals')],
            
           
        ],'visible'=>Yii::$app->user->identity->role=='Client Admin' || Yii::$app->user->identity->role=='Shop Manager'  ? true : false],

         ['label' => 'Register', 'icon' => 'book', 'items' => [
            ['label' => '<span class="pull-right badge"></span> My Ledger', 'url' => Url::to(['/transaction/mledger', 'type'=>$type]), 'active' => ($item == 'new-arrivals')],
            
                          ['label' => '<span class="pull-right badge"></span> Other Users Ledger', 'url' => Url::to(['/transaction/uledger', 'type'=>$type]), 'active' => ($item == 'new-arrivals'),'visible'=>Yii::$app->user->identity->role=='Client Admin'  ? true : false], 
             
        ]],

         ['label' => 'Production', 'icon' => 'book', 'items' => [
           
             ['label' => '<span class="pull-right badge"></span> Production Manager Ledger', 'url' => Url::to(['/transaction/mmledger', 'type'=>$type]), 'active' => ($item == 'new-arrivals'),'visible'=>Yii::$app->user->identity->role=='Client Admin'  ? true : false], 
                         
              ['label' => '<span class="pull-right badge"></span>Production Ledger', 'url' => Url::to(['/transaction/pledger', 'type'=>$type]), 'active' => ($item == 'new-arrivals'),'visible'=>Yii::$app->user->identity->role=='Client Admin' || Yii::$app->user->identity->role=='Production Manager'  ? true : false],           
         ['label' => '<span class="pull-right badge"></span>Batch Ledger', 'url' => Url::to(['/transaction/bledger', 'type'=>$type]), 'active' => ($item == 'new-arrivals'),'visible'=>Yii::$app->user->identity->role=='Client Admin' || Yii::$app->user->identity->role=='Production Manager'  ? true : false],           
        ]],

        //  ['label' => 'Customers', 'icon' => 'book', 'items' => [
        // ['label' => '<span class="pull-right badge"></span> Customer Details', 'url' => Url::to(['/customers/index', 'type'=>$type]), 'active' => ($item == 'new-arrivals')],
        // ['label' => '<span class="pull-right badge"></span> Customer Ledger', 'url' => Url::to(['/customers/cledger', 'type'=>$type]), 'active' => ($item == 'new-arrivals')],
            
        // ]],
        //     ['label' => 'Vendors', 'icon' => 'book', 'items' => [
        //      ['label' => '<span class="pull-right badge"></span> Vendors', 'url' => Url::to(['/vendors/index', 'type'=>$type]), 'active' => ($item == 'most-popular')],
        //      ['label' => '<span class="pull-right badge"></span> Vendor Ledger', 'url' => Url::to(['/vendors/vledger', 'type'=>$type]), 'active' => ($item == 'new-arrivals')],
            
        // ]],
    ],
]);        
        ?>
        <div id="loader" style="display:none;"><?php echo Html::img('@web/loaders/loader11.gif', ['class' => 'pull-center img-responsive']); ?></div>
            </div>

            <div id="content" class="col-sm-9">
                    <?php echo $content; ?>
            </div><!-- content -->

            

        </div>
<?php $this->endContent();