<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "areports".
 *
 * @property int $id
 * @property int $item_id
 * @property int $source
 * @property double $quantity
 * @property string $created_at
 * @property int $cid
 * @property int $direction
 */
class Areports extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'areports';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['item_id', 'source', 'quantity', 'created_at', 'cid', 'direction'], 'required'],
            [['item_id', 'source', 'cid', 'direction'], 'integer'],
            [['quantity'], 'number'],
            [['created_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'item_id' => 'Item ID',
            'source' => 'Source',
            'quantity' => 'Quantity',
            'created_at' => 'Created At',
            'cid' => 'Cid',
            'direction' => 'Direction',
        ];
    }
}
