<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "customers".
 *
 * @property int $id
 * @property string $name
 * @property string $address
 * @property string $email
 * @property string $phone
 * @property int $cid
 * @property string $created_at
 * @property string $updated_at
 */
class Customers extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'customers';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['name', 'cid'], 'required'],
            [['address'], 'string'],
            [['cid'], 'integer'],
            [['created_at', 'updated_at'], 'safe'],
            [['name'], 'string', 'max' => 225],
            [['email'], 'string', 'max' => 60],
            [['phone'], 'string', 'max' => 20],
            
        ];
    }

    // public function beforeValidate()
    // {
    //     $search=['"','\'','#'];
    //        if(!empty($this->name))
    //        {
    //         str_replace($search, " ", $this->name);
    //         return $this->name;
    //        }
    //     return parent::beforeValidate();
    // }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Name',
            'address' => 'Address',
            'email' => 'Email',
            'phone' => 'Phone',
            'cid' => 'Cid',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }
}
