<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "entry".
 *
 * @property int $id
 * @property double $amount
 * @property int $chart_account
 * @property int $entry_type
 * @property int $entry_group
 * @property int $cid
 * @property string $created_at
 * @property string $updated_at
 * @property int $fid
 * @property int $account_group
 * @property int $who
 * @property string $dsource
 * @property string $transaction_id
 * @property int $lid
 */
class Entry extends \yii\db\ActiveRecord
{
    public $dcode; public $dcode2;
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'entry';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['amount', 'chart_account', 'entry_type', 'entry_group', 'cid', 'created_at', 'account_group', 'who', 'dsource'], 'required'],
            [['amount'], 'number'],
            [['chart_account', 'entry_type', 'entry_group', 'cid', 'fid', 'account_group', 'who', 'lid'], 'integer'],
            [['created_at', 'updated_at'], 'safe'],
            [['dsource'], 'string', 'max' => 3],
            [['transaction_id'], 'string', 'max' => 200],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'amount' => 'Amount',
            'chart_account' => 'Chart Account',
            'entry_type' => 'Entry Type',
            'entry_group' => 'Entry Group',
            'cid' => 'Cid',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'fid' => 'Fid',
            'account_group' => 'Account Group',
            'who' => 'Who',
            'dsource' => 'Dsource',
            'transaction_id' => 'Transaction ID',
            'lid' => 'Lid',
        ];
    }
}
