<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "price_category".
 *
 * @property int $id
 * @property string $category_name
 * @property int $cid
 * @property double $mark_up
 * @property string $created_at
 */
class PriceCategory extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'price_category';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['category_name', 'cid', 'mark_up', 'created_at'], 'required'],
            [['cid'], 'integer'],
            [['mark_up'], 'number'],
            [['created_at'], 'safe'],
            [['category_name'], 'string', 'max' => 255],
            [['category_name'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'category_name' => 'Category Name',
            'cid' => 'Cid',
            'mark_up' => 'Mark Up',
            'created_at' => 'Created At',
        ];
    }
}
