<?php

namespace frontend\models;

use Yii;

/**
 * This is the model class for table "productions".
 *
 * @property int $id
 * @property int $item_id
 * @property string $item_name
 * @property double $quantity
 * @property int $cid
 * @property string $created_at
 * @property string $updated_at
 * @property int $staff
 */

class Productions extends \yii\db\ActiveRecord implements \yz\shoppingcart\CartPositionInterface
{
  
   // public $price;
    
  

    use  \yz\shoppingcart\CartPositionTrait;
    public function getPrice()
    {
        return $this->price;
    }

    public function getId()
    {
        return $this->id;
    }

    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'productions';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['item_id', 'item_name', 'quantity', 'cid', 'staff'], 'required'],
            [['item_id', 'cid', 'staff'], 'integer'],
            [['quantity'], 'number'],
            [['created_at', 'updated_at'], 'safe'],
            [['item_name'], 'string', 'max' => 225],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'item_id' => 'Item ID',
            'item_name' => 'Item Name',
            'quantity' => 'Quantity',
            'cid' => 'Cid',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'staff' => 'Staff',
        ];
    }
}
