<?php

namespace frontend\models;

use Yii;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use frontend\models\Sales;

/**
 * SearchSales represents the model behind the search form of `frontend\models\Sales`.
 */
class SearchSales extends Sales
{
    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['id', 'cid', 'item_id', 'customer_id', 'staff', 'supplier'], 'integer'],
            [['item_name', 'transaction_id', 'payment_type', 'created_at', 'updated_at'], 'safe'],
            [['qty', 'supply_price', 'unit_price', 'total', 'tax', 'discount', 'tendered', 'balance'], 'number'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Sales::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id' => $this->id,
            'cid' => $this->cid,
            'item_id' => $this->item_id,
            'qty' => $this->qty,
            'supply_price' => $this->supply_price,
            'unit_price' => $this->unit_price,
            'total' => $this->total,
            'customer_id' => $this->customer_id,
            'staff' => $this->staff,
            'tax' => $this->tax,
            'discount' => $this->discount,
            'tendered' => $this->tendered,
            'balance' => $this->balance,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'supplier' => $this->supplier,
        ]);

        $query->andFilterWhere(['like', 'item_name', $this->item_name])
            ->andFilterWhere(['like', 'transaction_id', $this->transaction_id])
            ->andFilterWhere(['like', 'payment_type', $this->payment_type]);

        return $dataProvider;
    }
}
