<?php

use yii\helpers\Html;
use yii\widgets\DetailView;
use backend\models\User;
use backend\models\Departments;

/* @var $this yii\web\View */
/* @var $model backend\models\Authorizers */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Authorizers', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="authorizers-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
             ['label'=>'Department', 'format'=>'raw', 'value'=>ucwords(Departments::findOne($model->department)->department_name)],                   
             ['label'=>'Authorizer', 'format'=>'raw', 'value'=>ucwords(User::findOne($model->authorizer)->first_name)],       
            'cid',
        ],
    ]) ?>

</div>
