<?php
use yii\helpers\Html;
use backend\models\Designation;
use backend\models\Departments;
use backend\models\Clients;
use frontend\models\Shops;
use frontend\models\ShopTypes;
use yii\helpers\Url;

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Clients', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;

?>
<H3>View Users for <?php echo ucwords(Clients::findOne($id)->client_name); ?></H3>
<div>
<?= Html::a('Add User',['/site/clientsignup','id'=>$id],['class'=>'btn btn-primary']) ?> &nbsp;
<?= Html::a(ucwords(Clients::findOne($id)->client_name),['/clients/view','id'=>$id],['class'=>'btn btn-primary']) ?>
</div>

<table class="table table-bordered table-striped">
	<tr style="font-weight:bold;">
<td>Staff Name</td><td>Username</td><td>Workgroup</td><td>Group Position</td> <td>Client Role</td> <td>Action</td><td>Shop</td><th>Shop Type</th><td></td>
	</tr>
	<?php foreach($users as $user)
	{
		$dshop=Shops::findOne($user->shop_id);
		?>

<tr>
<td><?= ucwords($user->first_name.' '.$user->last_name) ?></td>
<td><?= ucwords($user->username) ?></td>
<td><?= Departments::findOne($user->department)->department_name ?></td>
<td><?= !empty($user->place) ? ($user->place==1 ? 'Group Head' : 'Group Member') : 'Not Set'   ?></td>
<td><?= $user->role ?></td>
<td> <?= Html::a('Edit User',['/user/update','id'=>$user->id,'cid'=>$id],['class'=>'btn btn-primary']) ?>

            <!--?= Html::a('Edit Users',Url::to(['user/update']),['data-method' => 'POST','class'=>'btn btn-danger','data-params'=>['id'=>$user->id,'cid'=>$id]]) ?-->

</td>
<td><?= ucwords($dshop->name) ?></td>
<td><?= ucwords(ShopTypes::findOne($dshop->shop_type)->type) ?></td>
<?php if($user->status==10){ ?>
<td> <?= Html::a('Suspend User',['/site/suspend','id'=>$user->id,'cid'=>Yii::$app->request->get('id')],['class'=>'btn btn-danger ', 'style'=>'','data'=>['confirm'=>'Suspend this User?']]) ?></td>
<?php }elseif ($user->status==0) { ?>
	<td> <?= Html::a('Activate User',['/site/suspend','id'=>$user->id,'cid'=>Yii::$app->request->get('id')],['class'=>'btn btn-warning ', 'style'=>'','data'=>['confirm'=>'Activate this User?']]) ?></td>
	<?php
}
?>
</tr>


		<?php
	}

?>


</table>
<?php



?>