<?php

use yii\helpers\Html;
use yii\grid\GridView;
use frontend\models\Inventory;

/* @var $this yii\web\View */
/* @var $searchModel backend\models\RoomsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Rooms';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="rooms-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
          <?= Html::a('Create Room Nos', ['create', 'id' => Yii::$app->request->get('id')], ['class' => 'btn btn-primary']) ?>
    </p>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        // 'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            // 'id',
            // 'room_type',
            ['label'=>'Room Type', 'format'=>'raw', 'attribute'=>'room_type', 'value'=>function ($model){  return ucwords(Inventory::findOne($model->room_type)->name); }], 
           
            'room_range:ntext',
            // 'cid',
            'total_rooms',
            //'rooms:ntext',

           ['class' => 'yii\grid\ActionColumn'],
          //    [
          // 'class' => 'yii\grid\ActionColumn',
          // 'header' => 'Actions',
          // 'headerOptions' => ['style' => 'color:#337ab7'],
          // 'template' => '{view}{update}',
          // 'buttons' => [
          //   'view' => function ($url, $model) {
          //       return Html::a('<span class="glyphicon glyphicon-eye-open"></span>', $url, [
          //                   'title' => Yii::t('app', 'lead-view'),
          //       ]);
          //   },

          //   'update' => function ($url, $model) {
          //       return Html::a('<span class="glyphicon glyphicon-pencil"></span>', $url, [
          //                   'title' => Yii::t('app', 'lead-update'),
          //       ]);
          //   },
          //   'delete' => function ($url, $model) {
          //       return Html::a('<span class="glyphicon glyphicon-trash"></span>', $url, [
          //                   'title' => Yii::t('app', 'lead-delete'),
          //       ]);
          //   }

          // ],
          // 'urlCreator' => function ($action, $model, $key, $index) {
          //   if ($action === 'view') {
          //       $url ='index.php?r=rooms/view&id='.$model->id.'&cid='.Yii::$app->request->get('id');
          //       return $url;
          //   }

          //   if ($action === 'update') {
          //       $url ='index.php?r=rooms/update&id='.$model->id.'&cid='.Yii::$app->request->get('id');
          //       return $url;
          //   }
          //   if ($action === 'delete') {
          //       $url ='index.php?r=rooms/delete&id='.$model->id.'&cid='.Yii::$app->request->get('id');
          //       return $url;
          //   }

          // }
          // ],
        ],
    ]); ?>
</div>
