<?php

use yii\helpers\Html;
use yii\grid\GridView;
use frontend\models\Inventory;

/* @var $this yii\web\View */
/* @var $searchModel backend\models\Rooms2Search */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Rooms Plus';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="rooms2-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
         <?= Html::a('Create Room Nos', ['create', 'id' => Yii::$app->request->get('id')], ['class' => 'btn btn-primary']) ?>
    </p>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            // 'id',
           // 'cid',
            'room_number',
            'price',
            'type',
            ['label'=>'Room Type', 'format'=>'raw', 'attribute'=>'type', 'value'=>function ($model){  return ucwords(Inventory::findOne($model->type)->name); }], 
            //'name',
            //'booked',
            //'status',
            //'shop_id',

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
</div>
