<?php

/* @var $this yii\web\View */
/* @var $form yii\bootstrap\ActiveForm */
/* @var $model \frontend\models\SignupForm */

use yii\helpers\Html;
use yii\bootstrap\ActiveForm;

use backend\models\Clients;

use yii\helpers\ArrayHelper;


$this->title = 'Create Losman Staff';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="site-signup">
    <h1><?= Html::encode($this->title) ?></h1>

    <p>Please fill out the following fields to signup:</p>

    <div class="row">
        <div class="col-lg-5">
            <?php $form = ActiveForm::begin(['id' => 'form-signup','action'=>Yii::$app->urlManager->createUrl('site/dos_update'),'method'=>'post']); ?>

                <?= $form->field($model, 'username')->textInput(['autofocus' => true]) ?>
                <?= $form->field($model, 'first_name')->textInput() ?>
                <?= $form->field($model, 'last_name')->textInput() ?>

                <?= $form->field($model, 'email') ?>
                
                <?php echo $form->field($model, 'role')->dropDownList(
    ['Staff'=>'Staff','Agent'=>'Agent','admin'=>'admin'],['prompt'=>''])->label('Role') ?>

                <?= $form->field($model, 'id')->hiddenInput()->label(false) ?>

                


                <div class="form-group">
                    <?= Html::submitButton('Update', ['class' => 'btn btn-primary', 'name' => 'update-button']) ?>
                </div>

            <?php ActiveForm::end(); ?>
        </div>
    </div>
</div>
