<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;

/* @var $this yii\web\View */
/* @var $model frontend\modules\hr\models\AdminDetails */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="admin-details-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'subject')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'subject_details')->textarea(['rows' => 6]) ?>

    <?= $form->field($model, 'staff_id')->hiddenInput(['value'=>$sid])->label(false) ?>

    <?php // echo $form->field($model, 'created_at')->hiddenInput(['maxlength' => true,'value'=>date('Y-m-d')])->label(false) ?>
    <?=  $form->field($model,'created_at')->widget(DatePicker::classname(),
    ['options'=>['placeholder'=>'Date','autocomplete'=>'Off'],
    'pluginOptions'=>[ 'autoclose'=>true,
                'format' => 'yyyy-mm-dd',
                'todayHighlight' => true,]])->label('Date') ?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
