<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model frontend\modules\hr\models\ClientUnits */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Client Units', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="client-units-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            'cid',
            'client_account',
            'unit_name',
            'unit_address:ntext',
            'created_at',
        ],
    ]) ?>

</div>
