<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;
use yii\helpers\ArrayHelper;
use frontend\modules\hr\models\Designate;
use frontend\modules\hr\models\Section;
use frontend\modules\hr\models\Locations;
use frontend\modules\hr\models\Cadre;
use frontend\modules\hr\models\EmploymentType;
use frontend\modules\hr\models\ClientAccount;

/* @var $this yii\web\View */
/* @var $model frontend\modules\hr\models\EmploymentDetails */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="employment-details-form">

    <?php $form = ActiveForm::begin(); ?>

    
    <?=  $form->field($model,'employment_date')->widget(DatePicker::classname(),
    ['options'=>['placeholder'=>'Employment Date','autocomplete'=>'Off'],
    'pluginOptions'=>[ 'autoclose'=>true,
                'format' => 'yyyy-mm-dd',
                'todayHighlight' => true,]]) ?>

    
     <?= $form->field($model, 'designation')->dropDownList(ArrayHelper::map(Designate::find()->where(['cid'=>Yii::$app->user->identity->cid])->orderBy(['designation_name'=>'asc'])->all(),'id','designation_name'),['class'=>'form-control','prompt'=>'','id'=>'designation'])->label('Designatino Name') ?>

  

    
     <?= $form->field($model, 'section')->dropDownList(ArrayHelper::map(Section::find()->where(['cid'=>Yii::$app->user->identity->cid])->orderBy(['section_name'=>'asc'])->all(),'id','section_name'),['class'=>'form-control','prompt'=>'','id'=>'section']) ?>

    
     <?= $form->field($model, 'employment_type')->dropDownList(ArrayHelper::map(EmploymentType::find()->orderBy(['name'=>'asc'])->all(),'id','name'),['class'=>'form-control','prompt'=>'','id'=>'section'])->label('Employment Type') ?>


     <?= $form->field($model, 'client')->dropDownList(ArrayHelper::map(ClientAccount::find()->where(['cid'=>Yii::$app->user->identity->cid])->orderBy(['client_name'=>'asc'])->all(),'id','client_name'),['class'=>'form-control','id'=>'client', 'prompt'=>'','onchange'=>'getunits2()','value'=>$model->client])->label('Section') ?>
     <div id="list" class="" style="margin-bottom:10px; font-weight: bold;">
        <?= !empty($model->location) ? 'Current Location is : '.\frontend\modules\hr\models\ClientUnits::findOne($model->location)->unit_address : '' ?>
     </div>
    
    

    
     <?= $form->field($model, 'cadre')->dropDownList(ArrayHelper::map(Cadre::find()->where(['cid'=>Yii::$app->user->identity->cid])->orderBy(['cadre_type'=>'asc'])->all(),'id','cadre_type'),['class'=>'form-control','prompt'=>'','id'=>'cadre'])->label('Cadre') ?>

     <?= $form->field($model, 'shift_hours')->textInput() ?>

     <?= $form->field($model, 'gross_pay')->textInput() ?>

    <?= $form->field($model, 'supervisor_name')->textInput() ?>

    <?= $form->field($model, 'staff_id')->hiddenInput(['value'=>Yii::$app->request->get('sid')])->label(false) ?>
     <?= $form->field($model, 'cid')->hiddenInput(['value'=>Yii::$app->user->identity->cid])->label(false) ?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
