<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;
use frontend\modules\hr\models\Nationality;
use yii\helpers\ArrayHelper;


/* @var $this yii\web\View */
/* @var $model frontend\modules\hr\models\PersonalDetails */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="personal-details-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'cid')->hiddenInput(['value'=>Yii::$app->user->identity->cid])->label(false) ?>

    <?= $form->field($model, 'surname')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'firstname')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'other_names')->textInput() ?>
    

    <?=  $form->field($model,'dob')->widget(DatePicker::classname(),
    ['options'=>['placeholder'=>'Date of birth','autocomplete'=>'Off'],
    'pluginOptions'=>[ 'autoclose'=>true,
                'format' => 'yyyy-mm-dd',
                'todayHighlight' => true,]]) ?>

    
     <?= $form->field($model, 'nationality')->dropDownList(ArrayHelper::map(Nationality::find()->orderBy(['nation'=>'asc'])->all(),'id','nation'),['class'=>'form-control','prompt'=>'','id'=>'nationality'])->label('Select Nationality') ?>

    <?= $form->field($model, 'nin')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'nir')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'tin')->textInput(['maxlength' => true]) ?>
    
    <?=  $form->field($model, 'marital_status')->dropDownList([1=>'Single',2=>'Married'],['class'=>'form-control','prompt'=>'Marital Status','id'=>'ms'])->label('Marital Status') ?>


    <?= $form->field($model, 'name_of_spouse')->textInput() ?>

    
    <?= $form->field($model, 'residential_address')->textarea(['rows' => 6]) ?>

    <?= $form->field($model, 'permanent_home_address')->textarea(['rows' => 6]) ?>
    

    <?= $form->field($model, 'telephone')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'email')->textInput(['maxlength' => true]) ?>

    
    <?=  $form->field($model, 'gender')->dropDownList([1=>'Male',2=>'Female'],['class'=>'form-control','prompt'=>'Gender','id'=>'gender'])->label('Gender') ?>

    <?= $form->field($model, 'address_of_spouse')->textarea(['rows' => 6]) ?>

    
    <?=  $form->field($model, 'account_type')->dropDownList([1=>'Savings',2=>'Current'],['class'=>'form-control','prompt'=>'Account type','id'=>'ac'])->label('Account type') ?>

    <?= $form->field($model, 'account_number')->textInput() ?>

    <?= $form->field($model, 'spouse_telephone')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'name_of_banker')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'name_of_PFA')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'name_of_PFC')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'RSA_number')->textInput(['maxlength' => true]) ?>

    <?=  $form->field($model, 'activate_attendance')->dropDownList([1=>'Active',2=>'Inactive'],['class'=>'form-control','prompt'=>'','id'=>'activate_attendance'])->label('Activate Attendance') ?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
