<style type="text/css">
.bold{
    font-weight: bold;
}
</style>
<?php

use yii\helpers\Html;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel frontend\modules\hr\models\PersonalDetailsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Staff Personal Details';
$this->params['breadcrumbs'][] = $this->title;
// var_dump($searchModel); die;
?>
<div class="personal-details-index">

    <h1><?= Html::encode($this->title) ?></h1>
    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <p>
        <?= Html::a('Create Personal Details', ['create'], ['class' => 'btn btn-success']) ?>
    </p>
    <table class="table table-bordered table-striped">
        <tr>
            <th colspan="4" style="font-size:22px;">SPECIAL FILTER KEYS</th>
        </tr>

        <tr>
            <td class="bold">Section</td>
            <td>
<?php
use frontend\modules\hr\models\Section;
$sections=Section::find()->where(['cid'=>Yii::$app->user->identity->cid])->all();
foreach($sections as $section)
{
    echo $section->section_name."-".$section->id.", ";
}
?>
            </td>
       
            <td class="bold">Employment Type</td>
            <td>Permanent - 1, Casual - 2</td>
        </tr>
        <tr>
            <td class="bold">Approval Status</td>
            <td>Pending Approval - 1, Approved - 2</td>
       
            <td class="bold">Gender</td>
            <td>Male - 1, Female - 2</td>
        </tr>

    </table>
<?php
$club='edetails.section';
$emtype='edetails.employment_type';
?>
    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            // ['class' => 'yii\grid\SerialColumn'],

            // 'id',
             [
                'label'=>'Staff ID',
                'attribute'=>'id',
                'value'=>function($data){
                    
                     return "MRL".str_pad($data->id, 5,0, STR_PAD_LEFT);
                 }                
            ],
            // 'cid',
            'surname',
            'firstname',
            'other_names',
            //'dob',
            //'nationality',
            //'nin',
            //'nir',
            //'tin',
            //'marital_status',
            //'name_of_spouse',
            'residential_address',
            'telephone',
            // 'email:email',
            'gender',
            //'address_of_spouse:ntext',
            //'account_type',
            // 'account_number',
            'spouse_telephone',
            //'name_of_banker',
            //'name_of_PFA',
            //'name_of_PFC',
            //'RSA_number',
            // 'edetails.section',
            'approved',
            [
                'label'=>'Section',
                'attribute'=>'sectoral',
                'value'=>function($data,$club){
                    $sec=\frontend\modules\hr\models\Section::find()->where(['id'=>$club])->one()->section_name;
                     return $sec;
                }
                
            ],
            [
                'label'=>'Employment Type',
                'attribute'=>'emtype',
                'value'=>function($data,$emtype){
                    $jec=\frontend\modules\hr\models\EmploymentType::find()->where(['id'=>$emtype])->one()->name;
                     return $jec;
                 }
            ],
            // 'approved',

            ['class' => 'yii\grid\ActionColumn'],
        ],
    ]); ?>
</div>
