<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use frontend\modules\hr\models\ClientAccount;
use frontend\modules\hr\models\ClientUnits;
use frontend\modules\hr\models\Section;

use yii\helpers\ArrayHelper;
use kartik\date\DatePicker;
?>



<h1>View Attendance</h1>

<div>
<div>
	<?php $form = ActiveForm::begin(['action'=>Yii::$app->urlManager->createUrl('hr/personaldetails/viewattendance')]) ?>

<?php
echo '<label class="control-label">From</label>';
echo DatePicker::widget([
    'name' => 'from',
    'id' => 'from',
    'options' => ['autocomplete'=>'Off','style'=>''],
    //'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,
       
    ]
]); ?>


<?php
echo '<label class="control-label">To</label>';
echo DatePicker::widget([
    'name' => 'to',
    'id' => 'to',
    'options' => ['autocomplete'=>'Off','style'=>''],
    //'value' => date('Y-m-d'),
    'pluginOptions' => [
        'autoclose'=>true,
        'format' => 'yyyy-mm-dd',
        'todayHighlight' => true,
       
    ]
]); ?>

<?= Html::dropDownList('client',null, ArrayHelper::map(ClientAccount::find()->where(['cid'=>Yii::$app->user->identity->cid])->all(),'id','client_name'),['class'=>'form-control','prompt'=>'','id'=>'client','onchange'=>'atform()','style'=>'margin-top:20px;']) ?>
 
<div id="list" style="margin-top:20px;">

</div>

<div>
<?= Html::submitButton('Fetch Attendance',['class'=>'btn btn-primary','style'=>'float:right;']) ?>
</div>
<?php ActiveForm::end(); ?>


</div>

<div id="staff">

	<?php
		if($staff!=null)
		{
			?>
			<table class="table table-bordered table-striped">
				<tr>
					<th>STAFF</th>
					<th>HOURS WORKED</th>
				</tr>

				<?php
					foreach($staff as $sta)
					{
						?>
							<tr id="<?= $sta['id'] ?>remove">
								<td><?php $name=\frontend\modules\hr\models\PersonalDetails::findOne($sta['staff']); echo $name->surname.' '.$name->firstname ?></td>
								<td><?= $sta['work_hours']/60 ?></td>
								<td><?= Yii::$app->user->identity->place==1 ? Html::button('Delete',['class'=>'btn btn-danger','onclick'=>'remove_attendance('.$sta['id'].')']) : '' ?></td>
							</tr>
						<?php
					}
				?>
			</table>

			<?php
		}
	?>
</div>


</div>

