<?php

namespace frontend\controllers;

use Yii;
use frontend\models\Purse;
use frontend\models\PurseSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use frontend\models\History;

/**
 * PurseController implements the CRUD actions for Purse model.
 */
class PurseController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Purse models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new PurseSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Purse model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Purse model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new Purse();

        if ($model->load(Yii::$app->request->post()) && $model->validate()) {

                  $transaction = Yii::$app->db->beginTransaction();
 try {

            $check=Purse::find()->where(['account'=>$model->account])->one();
            if($check==null){
                if(!$model->save())
                {
                    throw new \Exception( 'could not save to purse' );
                }

            }else{
                $check->amount+=$model->amount;
                if(!$check->save())
                {
                    throw new \Exception( 'could not save to purse' );
                }
            }

            $history=new History;
            $history->amount=$model->amount;
            $history->account=$model->account;
            $history->cid=Yii::$app->user->identity->cid;
            $history->created_at=date('Y-m-d');
            if(!$history->save())
            {
                throw new \Exception( 'could not save to history account' );
            }

             $transaction->commit();

            } catch (\Exception $e) {
                $transaction->rollBack();
                throw $e; die('failed');
            } catch (\Throwable $e) {
                $transaction->rollBack();
                throw $e; die('failed');
            }

            return $this->redirect(['done']);
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Purse model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Purse model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Purse model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Purse the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Purse::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    public function actionDone()
    {
        return $this->render('done');
    }
}
