<?php

namespace frontend\controllers;

use Yii;
use frontend\models\Requisitions;
use frontend\models\RequisitionsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use backend\models\Workflow;
use frontend\models\Notifications;
use backend\models\RequisitionTypes;
use frontend\models\Ledger;
use frontend\models\Items;
use frontend\models\Stores;
use frontend\models\StoresHistory;
use backend\models\User;
use frontend\models\Messages;
use yii\filters\AccessControl;
use backend\models\Transfers;
use backend\models\TransfersHistory;
use frontend\models\Inventory;
use backend\models\Tasks;
use frontend\models\Vendors;
use frontend\models\Productions;
use frontend\models\Banks;
use frontend\models\ShopHistory;
use frontend\models\Twin;
use frontend\models\Charts;
use frontend\models\Entry;
use frontend\models\Leap;
use yii\web\Session;

date_default_timezone_set('Africa/Lagos');

/**
 * RequisitionsController implements the CRUD actions for Requisitions model.
 */
class RequisitionsController extends Controller
{
    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'allow' => true,
                        'actions' => ['index', 'view', 'create', 'delete', 'update', 'findModel', 'viewrequisition',
                        'approve', 'decline2', 'decline', 'myrequisitions', 'requisitiondetails',
                        'attentionrequired', 'allrejections', 'allnotifications',
                        'viewnotification', 'outflow', 'land', 'editr', 'viewrejections', 'edelete','allrequisitions','rain'
                    ],
                    'roles' => ['@'],
                ],

                [
                    'allow' => true,
                    'actions' => ['allrequisitions'],
                    'roles' => ['Client Admin'],
                ],
                [
                    'allow' => true,
                    'actions' => ['pnl','pnld'],
                    'roles' => ['Client Admin', 'accounts'],
                ],
            ],
        ],
        'verbs' => [
            'class' => VerbFilter::className(),
            'actions' => [
                'delete' => ['POST'],
            ],
        ],
    ];
}

    /**
     * Lists all Requisitions models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new RequisitionsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Requisitions model.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Requisitions model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $cart = new  \yz\shoppingcart\ShoppingCart();
        //\Yii::$app->cart->removeAll();
        $cart->removeAll();
        $model = new Requisitions();

        if ($model->load(Yii::$app->request->post())) {
            $model->transaction_id = time() . rand(1, 9);

            $ben = array();


            foreach ($model->requested_item as $req) {
                $req['amount'];
                $req['total'] = $req['amount'] * $req['quantity'];

                $ben[] = array('item_name' => $req['item_name'], 'details' => $req['details'], 'quantity' => $req['quantity'], 'amount' => $req['amount'], 'total' => $req['total']);

            }
            $model->requested_item = json_encode($ben);

            // var_dump($model->requested_item);
            if (!$model->save()) {
                var_dump($model->getErrors());
                die;
            }


            if ($model->save()) {

                return $this->redirect(['view', 'id' => $model->id]);
            }
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Requisitions model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {

            $flow_array = explode(',', $model->not_seen);
            $model->status = $flow_array[0];
            $model->rejected = 0;


            $ben = array();

            foreach ($model->requested_item as $req) {
                echo $req['amount'];
                echo "<br>";
                echo $req['total'] = $req['amount'] * $req['quantity'];
                echo "<br >";
                $ben[] = array('item_name' => $req['item_name'], 'details' => $req['details'], 'quantity' => $req['quantity'], 'amount' => $req['amount'], 'total' => $req['total']);

            }
            $model->requested_item = $ben;

            $model->save();
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Requisitions model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }


    /**
     * Finds the Requisitions model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Requisitions the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Requisitions::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }


    public function actionViewrequisition($id, $doc)
    {
        unset($session['invo']);
        $find=Leap::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['staff'=>Yii::$app->user->identity->id])->one();
        if($find!=NULL){

        }
        $record = Requisitions::findOne($id);
        Leap::deleteAll(['cid'=>Yii::$app->user->identity->cid,'staff'=>Yii::$app->user->identity->id]);
        // var_dump($record); die;
        $doca = $record->instrument;
        $see = $record->status;
        return $this->render('view_requisition', ['record' => $record, 'document' => $doca, 'see' => $see]);
    }

    public function actionViewnotification($id, $doc)
    {
        $record = Requisitions::findOne($id);
        $doca = $record->instrument;
        $see = $record->status;

        //$note = Notifications::find()->where(['=', 'notify', Yii::$app->user->identity->id])->all();
        $note = Notifications::find()->where(['=', 'req_id', $id])->one();
        // foreach ($note as $no) {
        //     $no->status = 1;
        //     $no->save();
        // }
        $note->status=1;
        $note->save();

        return $this->render('view_notification', ['record' => $record, 'document' => $doc, 'see' => $see]);
    }

    public function actionApprove($id, $doc)
    {

        ob_start();

        $session=Yii::$app->session;
        if($session->has('invo'))
        {
          $invoice_id=$session['invo'];
      }

        // account_type was set as cash until journal entry request
        // a default account_type of cash makes for bad accounting and makes journal entry useless so should be changed from cash
        // $account_type='cash';
        $account_type='cash_not'; /* this tells us that we are running cash based accounting and not accrual based accounting. i set this 
        variable here manually so i can force dummy variables for chart_account and chart_account2 and other dummy variables used to make 
        entry into the entry database for the first leg of double 
        leg accounting which the software still works with */


        $work = Requisitions::findOne($id);
        $workflow = Workflow::findOne($work->workflow_id);
        $task = Tasks::findOne($workflow->task_id);
        // var_dump($task->finisher); die;
        $flows = explode(',', $workflow->int_workflow);
        $next_status = '';
        $current_index = $work->current_index;
        $kept_index = $work->current_index;  

        //$ctwin=Twin::find()->where(['cid'=>Yii::$app->user->identity->cid])->one(); if(empty($ctwin->debit_sale) || empty($ctwin->credit_sale) || empty($ctwin->debit_expense) || empty($ctwin->credit_expense)) { die('Please set up twin accounts before proceeding'); }

        $documents = explode(',', $workflow->instrument);
        
        $status_array = explode(',', $workflow->status_id);
        $show_what = $status_array[$work->current_index];

        $stamp = explode(',', $workflow->status_id);

        $available=0;
        $index = $current_index;
        if($work->rejected!=1){
            if (isset($flows[$index + 1])) {

                if ($work->status == $work->raised_by) {
                    $next_status = $flows[0];
                } else {
                    $next_status = $flows[$index + 1];
                }

            } else {

                $next_status = $flows[$kept_index];
                $work->concluded = 1;

            }
        }

        $next_doc = '';
        
        $index_doc = $current_index;
        if($work->rejected!=1){
            if (isset($documents[$index_doc + 1])) {


                if ($work->status == $work->raised_by) {
                    $next_doc = $documents[0];
                } else {
                    $next_doc = $documents[$index_doc + 1];
                    $current_index += 1;
                }

            } else {
                $next_doc = $documents[$kept_index];
            // $work->concluded=1;
            }

        }
        $hop = json_decode($work->requested_item, true);
        $vendor = Vendors::findOne($hop[0]['vendor'])->name;
        $mike = $hop[0]['vendor'];
        $narate = $hop[0]['narration'];

        $hop2 = json_decode($work->requested_item, true);
        $customer = $hop2[0]['customer_name'];

        $leg = Banks::find()->where(['cid' => Yii::$app->user->identity->cid])->all();


        $total = 0;
        $goods = '';
        $qty = 0;
        $qty2 = 0;


        if ($work->task_type == 3) {


            if ($work->dsender_id == null && $stamp[$kept_index] == 5) {


              $transaction = Yii::$app->db->beginTransaction();
              try {

                foreach (json_decode($work->requested_item, true) as $item) {
                    $total += $item['total'];
                    $goods .= $item['item_name'] . ', ';
                    $qty += $item['quantity'];
                    $qty2 = $item['quantity'];


                    $row11 = explode(',', $workflow->status_id);
                    $row22 = explode(',', $workflow->int_workflow);
                    $reid = array_search(5, $row11);
                    $rere = $row22[$reid];

                    $uti = Stores::findOne($item['item_id']);
if($uti->quantity<$qty2 && $uti->countable==1){ $available=1; } // check if there is sufficient quantity in store for the transfer
// there is sufficient then $available becomes 1

                // insert alert here
if($available==1)   {                                            


    $dim = new Messages();
    $dim->cid = Yii::$app->user->identity->cid;
    $dim->from_id = Yii::$app->user->identity->id;
    $dim->to_id = $work->raised_by;
    $dim->subject = $work->title . ' Insufficient Quantities';
    $dim->message = "One or more items on the invoice have Insufficient quantities";
    $dim->message_link = $work->transaction_id;
    if (!$dim->save()) {
        throw new \Exception('could not save to messages');
                                                            //var_dump($dim->getErrors()); die;
    }


    ?>
    <script type="text/javascript">
        alert('Insufficient Quantity on one or more of the Invoice Items. Transaction has been rejected and moved to rejected Items! Please locate in rejected items and address the issues'); 
    </script>

    <?php                             

}
                // close insert alert
if($available==1)
{                        
    $work->status = $work->raised_by;
    $work->rejected = 1;
    $work->instrument = $documents[0];
    $work->current_index = 0; 
    $work->concluded=0;
    if(!$work->save()){ var_dump($work->getErrors());  }


                            // throw new \Exception('Insufficient quantity on one of the items in invoice');

}
// if($available==1){ die; }
if($available==0){
    $storeh = new StoresHistory();
    $storeh->name = $uti->name;
    $storeh->cid = $uti->cid;
    $storeh->units = $uti->units;
    $storeh->standing_quantity = $uti->quantity;
    $storeh->particulars = $uti->particulars;
                    // $storeh->received_date=date('Y-m-d');
                    // $storeh->recieved_by=$uti->recieved_by;
    $storeh->recieved_by = $rere;
    $storeh->transaction_id = $uti->transaction_id;
    $storeh->balance = $uti->balance;
    $storeh->transaction_quantity = $qty2;
                    $storeh->type = 11; // reducing
                    $storeh->qout = $qty2;
                    $storeh->issued_date = date('Y-m-d');
                    $storeh->description = $uti->description;

                    $storeh->issued_by = Yii::$app->user->identity->id;
                    $storeh->given_to = $uti->given_to;
                    $storeh->item_id = $item['item_id'];
                    if (!$storeh->save()) {
                     throw new \Exception('could not save to store history');
                 }


                 $checkit = Transfers::find()->where(['=', 'reciever_id', $work->raised_by])->andWhere(['=', 'item_id', $item['item_id']])->one();
                 if ($checkit == null) {

                    $row11 = explode(',', $workflow->status_id);
                    $row22 = explode(',', $workflow->int_workflow);
                    $reid = array_search(5, $row11);
                    $rere = $row22[$reid];


                    $move = new Transfers();
                    $move->cid = Yii::$app->user->identity->cid;
                    $move->sender_id = Yii::$app->user->identity->id;
                    $move->reciever_id = $rere;
                    $move->item_id = $item['item_id'];
                    $move->item_name = $item['item_name'];
                    $move->quantity = $qty2;
                    $move->units = $uti->units;
                    $move->created_at = date('Y-m-d H:i:s');
                    if (!$move->save()) {
                     throw new \Exception('could not save to transfer');
                 }

             } else {
                $checkit->quantity += $qty2;
                if(!$checkit->save())
                {
                   throw new \Exception('could not save to transfer 2');
               }
           }


           $uti->quantity = ($uti->quantity - $qty2);
           if (!$uti->save()) {
             throw new \Exception('could not save to stores');
         }
     }


 }
 $transaction->commit();

} catch (\Exception $e) {
    $transaction->rollBack();
    throw $e;
    die('failed');
} catch (\Throwable $e) {
    $transaction->rollBack();
    throw $e;
    die('failed');
}


                } // close first foreach

           // } else { //remove here
                // run code if sender_id is not null
                
                
                if ($work->dsender_id != null && $stamp[$kept_index] == 5) {



                   $transaction = Yii::$app->db->beginTransaction();
                   try {


                    foreach (json_decode($work->requested_item, true) as $item) {
                        $total += $item['total'];
                        $goods .= $item['item_name'] . ', ';
                        $qty += $item['quantity'];
                        $qty2 = $item['quantity'];


                        $row11 = explode(',', $workflow->status_id);
                        $row22 = explode(',', $workflow->int_workflow);
                        $reid = array_search(5, $row11);
                        $rere = $row22[$reid];

                        $uti = Transfers::find()->where(['=', 'item_id', $item['item_id']])->andWhere(['=', 'reciever_id', $work->dsender_id])->one();
                        // var_dump($uti); die;
                        if($uti->quantity<$qty2 && $uti->countable==1){ $available=1;}

                         // insert alert here
                        if($available==1)   {                                            


                            $dim = new Messages();
                            $dim->cid = Yii::$app->user->identity->cid;
                            $dim->from_id = Yii::$app->user->identity->id;
                            $dim->to_id = $work->raised_by;
                            $dim->subject = $work->title . ' Insufficient Quantities';
                            $dim->message = "One or more items on the invoice have Insufficient quantities";
                            $dim->message_link = $work->transaction_id;
                            if (!$dim->save()) {
                                throw new \Exception('could not save to messages');
                                                            //var_dump($dim->getErrors()); die;
                            }


                            ?>
                            <script type="text/javascript">
                                alert('Insufficient Quantity on one or more of the Invoice Items. Transaction has been rejected!'); 
                            </script>

                            <?php                             

                        }
                // close insert alert
                        if($available==1)
                        {                        
                            $work->status = $work->raised_by;
                            $work->rejected = 1;
                            $work->instrument = $documents[0];
                            $work->current_index = 10000;
                            $work->save();
                            // die;
                            // // https://youtu.be/-ErsakzwLdU
                            // throw new \Exception('Insufficient quantity on one of the items in invoice');

                        }

                        if($available==0){
                            $store = Stores::findOne($item['item_id']);
                            $store->quantity += $qty2;


                            $storeh = new StoresHistory();
                            $storeh->name = $uti->item_name;
                            $storeh->cid = $uti->cid;
                        // $storeh->units=$uti->units;

                            $storeh->standing_quantity = $uti->quantity;
                            $storeh->particulars = 'Transfers';
                        // $storeh->received_date=date('Y-m-d');
                        // $storeh->recieved_by=$uti->recieved_by;
                            $storeh->recieved_by = $rere;
                            $storeh->transaction_id = 'Transfer';
                        // $storeh->balance=$uti->balance;
                            $storeh->transaction_quantity = $qty2;
                            $storeh->issued_date = date('Y-m-d');
                            $storeh->item_id = $item['item_id'];
                        $storeh->type = 12; // store increasing
                        $storeh->qin = $qty2;
                        // $storeh->description=$uti->description;

                        $storeh->issued_by = Yii::$app->user->identity->id;
                        $storeh->given_to = $work->raised_by;
                        if (!$storeh->save()) {
                         throw new \Exception('could not save to store history 3');
                     }


                     $sent = User::find()->where(['role' => 'Store Manager'])->andWhere(['cid' => Yii::$app->user->identity->cid])->one()->id;

                     $row11 = explode(',', $workflow->status_id);
                     $row22 = explode(',', $workflow->int_workflow);
                     $reid = array_search(5, $row11);
                     $rere = $row22[$reid];

                     $th = new TransfersHistory();
                     $th->cid = Yii::$app->user->identity->cid;
                     $th->sender_id = $sent;
                     $th->reciever_id = $rere;
                     $th->item_id = $item['item_id'];
                     $th->item_name = $item['item_name'];
                     $th->quantity = $qty2;
                     $th->created_at = date('Y-m-d H:i:s');
                     if (!$th->save()) {
                         throw new \Exception('could not save to transfer history 2');
                     }

                     if(!$store->save())
                     {
                      throw new \Exception('could not save to transfer');
                  }

                  $uti->quantity = ($uti->quantity - $qty2);
                  if (!$uti->save()) {
                     throw new \Exception('could not save to transfer');
                 }

             }
         }

         $transaction->commit();

     } catch (\Exception $e) {
        $transaction->rollBack();
        throw $e;
        die('failed');
    } catch (\Throwable $e) {
        $transaction->rollBack();
        throw $e;
        die('failed');
    }
              } // close try
            } // close if dsender is not null // remove here
         // close if task type==3 or transfer


        // another set of task type==5 and receive or move goods


            if ($work->task_type == 5) {

                $total = 0;
                $goods = '';
                $qty = 0;
                $qty2 = 0;

                if ($stamp[$kept_index] == 5 && $work->task_type == 5) {
                  $transaction = Yii::$app->db->beginTransaction();
                  try {
                    foreach (json_decode($work->requested_item, true) as $item) {
                    // $total+=$item['total'];
                        $goods .= $item['item_name'] . ', ';
                        $qty += $item['quantity'];
                        $qty2 = $item['quantity'];
                        $uti = Stores::find()->where(['id' => $item['item_id']])->andWhere(['cid'=>Yii::$app->user->identity->cid])->one();
                        $baba = Productions::find()->where(['item_id' => $item['item_id']])->andWhere(['cid' => Yii::$app->user->identity->cid])->one();

// start

                        if($baba->quantity<$qty2){ $available=1; }
// start
                        if($available==1)   {                                            


                            $dim = new Messages();
                            $dim->cid = Yii::$app->user->identity->cid;
                            $dim->from_id = Yii::$app->user->identity->id;
                            $dim->to_id = $work->raised_by;
                            $dim->subject = $work->title . ' Insufficient Quantities';
                            $dim->message = "One or more items on the invoice have Insufficient quantities";
                            $dim->message_link = $work->transaction_id;
                            if (!$dim->save()) {
                                throw new \Exception('could not save to messages');
                                                            //var_dump($dim->getErrors()); die;
                            }


                            ?>
                            <script type="text/javascript">
                                alert('Insufficient Quantity on one or more of the Voucher Items. Transaction has been rejected!'); 
                            </script>

                            <?php


                        }


                        if($available==1)
                        {                        
                            $work->status = $work->raised_by;
                            $work->rejected = 1; $work->concluded=0;
                            $work->instrument = $documents[0];
                            $work->current_index = 10000;
                            $work->save();
                            // die;
                            // // https://youtu.be/-ErsakzwLdU
                            // throw new \Exception('Insufficient quantity on one of the items in invoice');

                        }

// stop
                        if($available==0){



                    // shop history

                    // $shoph = new ShopHistory();
                    // $shoph->cid = Yii::$app->user->identity->cid;
                    // $shoph->name = $item['item_name'];
                    // $shoph->quantity = $item['quantity'];

                    // $shoph->price = 0;
                    // $shoph->staff = Yii::$app->user->identity->id;
                    // // $storeh->received_date=date('Y-m-d');
                    // $shoph->created_at = date('Y-m-d');
                    // $shoph->item_id = $item['item_id'];
                    // $shoph->issued_by = Yii::$app->user->identity->id;
                    // $shoph->received_by = $work->raised_by;
                    // $shoph->type = 1;
                    // $shoph->transaction_id = $work->transaction_id;
                    // $shoph->countable = 0;


                    // if (!$shoph->save()) {
                    //      throw new \Exception('could not save to ShopHistory');
                    // }

                            $storeh = new StoresHistory();
                            $storeh->name = $uti->name;
                            $storeh->cid = $uti->cid;
                    // $storeh->units=$uti->units;

                            $storeh->standing_quantity = $uti->quantity;
                            $storeh->particulars = 'Transfers';
                    // $storeh->received_date=date('Y-m-d');
                    // $storeh->recieved_by=$uti->recieved_by;
                            $storeh->recieved_by = $rere;
                            $storeh->transaction_id = 'Transfer';
                    // $storeh->balance=$uti->balance;
                            $storeh->transaction_quantity = $qty2;
                            $storeh->issued_date = date('Y-m-d');
                            $storeh->item_id = $item['item_id'];
                    $storeh->type = 12; // store increases
                    $storeh->qin=$qty2;
                    // $storeh->description=$uti->description;

                    $storeh->issued_by = Yii::$app->user->identity->id;
                    $storeh->given_to = $work->raised_by;
                    if (!$storeh->save()) {
                     throw new \Exception('could not save to store history 3');
                 }

                 $baba->quantity -= $qty2;
                 if (!$baba->save()) {
                    throw new \Exception('could not save to Productions');
                }

                    //$uti->quantity=($uti->quantity-$qty2);
                $uti->quantity += $qty2;
                if (!$uti->save()) {
                    throw new \Exception('could not save to inventory');
                }

            }
        }

        $transaction->commit();

    } catch (\Exception $e) {
        $transaction->rollBack();
        throw $e;
        die('failed');
    } catch (\Throwable $e) {
        $transaction->rollBack();
        throw $e;
        die('failed');
    }

}
        } // close task type==5


        // if task type==2

        if ($work->task_type == 2) {


            if (empty($leg)) {
                ?>
                <script type="text/javascript"> alert('You have not entered an opening balance!');
            return; </script>
            <?php die('You have not set an opening balance');
        }

            if (($documents[$kept_index] == 9) && $stamp[$kept_index] == 4) // if this document is invoice and logged in user is finisher


            {
                // $plan=Leap::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['staff'=>Yii::$app->user->identity->id])->andWhere(['se'=>1])->one();
    //             if($plan==NULL || $plan->debit_code<=0 || $plan->credit_code<=0 ){ die('Please go back and select accounts to debit and credit'); }
$plan=Twin::find()->where(['cid'=>Yii::$app->user->identity->cid])->one();
                $chart_account=$plan->debit_sale;
                $chart_account2=$plan->credit_sale;

                if($account_type=='cash'){
                    $chart_account=800000000;
                    $chart_account2=800000000;
                }


                $transaction = Yii::$app->db->beginTransaction();
                try {
                    //document or instrument is an invoice so credit ledger


                    foreach (json_decode($work->requested_item, true) as $item) {
                        $total += $item['total'];
                        // $goods.=$item['item_name'].', ';
                        // $qty+=$item['quantity'];
                        // $qty2=$item['quantity'];


                    }

                // save sales to ledger

                    $this->sales_to_ledger($work,$leg,$item,$chart_account,$chart_account2,$total,$customer);

        // entry stuff

        // post debit and credit entries for sales transaction

                    $this->post_sales_debit_credit($chart_account,$chart_account2,$work,$narate,$total);                 

        // end entry


                    // send notifications
                    $dnotice = explode(',', $workflow->notices);
                    if (count($dnotice) > 0 && $dnotice[0] != Null) {


                        foreach ($dnotice as $note) {
                            $notify = new Notifications();
                            $notify->cid = Yii::$app->user->identity->cid;
                            $notify->notify = $note;
                            $notify->link = $work->transaction_id;
                            $notify->action_by = Yii::$app->user->identity->id;
                            $notify->req_id = $work->id;
                            $notify->doc_id = $work->instrument;
                            $notify->workflow_id = $work->workflow_id;
                            $notify->concluded = $work->concluded;
                            $notify->rejected = $work->rejected;
                            $notify->message = $total . "  has been recieved by " . User::findOne(Yii::$app->user->identity->id)->last_name;
                            if (!$notify->save()) {
                                throw new \Exception('could not save notification');
                                //var_dump($notify->getErrors()); die;

                            }
                        }
                    }


                    // Leap::deleteAll(['cid'=>Yii::$app->user->identity->cid,'staff'=>Yii::$app->user->identity->id,'se'=>1]);
                    // var_dump($work->requested_item); die;

                    //  } // close if x == 0 for finisher

                    $transaction->commit();

                } catch (\Exception $e) {
                    $transaction->rollBack();
                    throw $e;
                    die('failed');
                } catch (\Throwable $e) {
                    $transaction->rollBack();
                    throw $e;
                    die('failed');
                }

            }

        }


        // another set
        if ($stamp[$kept_index] == 5 && $work->task_type == 2) {

          if (count($leg) == 0) {
            ?>
            <script type="text/javascript"> alert('You have not entered an opening balance!');
        return; </script>
        <?php die('You have not set an opening balance');
    }

    $connection = Yii::$app->db;
    $lock = $connection-> createCommand('LOCK TABLES `inventory` WRITE');

    $transaction = Yii::$app->db->beginTransaction();
    try {
                // run quantity check here

        foreach (json_decode($work->requested_item, true) as $item) {
            $total += $item['total'];
            $goods .= $item['item_name'] . ', ';
            $qty += $item['quantity'];
            $qty2 = $item['quantity'];

                    // start here

            if($item['countable']==1){
                $check=Inventory::findOne($item['id'])->quantity;
                if($check<$item['quantity'] && $check->countable==1)
                { 
                    $available=1;  }
                    if($available==1)   {                                            


                        $dim = new Messages();
                        $dim->cid = Yii::$app->user->identity->cid;
                        $dim->from_id = Yii::$app->user->identity->id;
                        $dim->to_id = $work->raised_by;
                        $dim->subject = $work->title . ' Insufficient Quantities';
                        $dim->message = "One or more items on the invoice have Insufficient quantities";
                        $dim->message_link = $work->transaction_id;
                        if (!$dim->save()) {
                            throw new \Exception('could not save to messages');
                                                            //var_dump($dim->getErrors()); die;
                        }


                        ?>
                        <script type="text/javascript">
                            alert('Insufficient Quantity on one or more of the Invoice Items. Transaction has been rejected!'); 
                        </script>

                        <?php


                    }
                }

                if($available==1)
                {                        
                    $work->status = $work->raised_by;
                    $work->rejected = 1; $work->concluded=0;
                    $work->instrument = $documents[0];
                    $work->current_index = 10000;
                    $work->save();
                            // die;
                            // // https://youtu.be/-ErsakzwLdU
                            // throw new \Exception('Insufficient quantity on one of the items in invoice');

                }

                    // end here

                if($available==0)
                {
                    $uti = Inventory::findOne($item['id']);
                    if ($item['countable'] == 1) {
                        $uti->quantity -= $qty2;
                    }



                    // }

                    if ($item['countable'] == 1 && $available==0) {
                        $shoph = new ShopHistory();
                        $shoph->cid = Yii::$app->user->identity->cid;
                        $shoph->name = $item['item_name'];
                        $shoph->quantity = $item['quantity'];

                        $shoph->price = 0;
                        $shoph->staff = Yii::$app->user->identity->id;
                    // $storeh->received_date=date('Y-m-d');
                        $shoph->created_at = date('Y-m-d');
                        $shoph->item_id = $item['item_id'];
                        $shoph->issued_by = Yii::$app->user->identity->id;
                        $shoph->received_by = $work->raised_by;
                    $shoph->type = 2; // shop inventory decreases
                    $shoph->transaction_id = $work->transaction_id;
                    $shoph->countable = 0;
                    $shoph->qout=$qty2;
                    $shoph->standing_quantity=$uti->quantity;


                    if (!$shoph->save()) {

                        throw new \Exception('could not save to shop history');
                        
                    }

                    if (!$uti->save()) {
                        throw new \Exception('could not save inventory');
                        
                    }
                }
            }
        }

        $transaction->commit();

    } catch (\Exception $e) {
        $transaction->rollBack();
        throw $e;
        die('failed');
    } catch (\Throwable $e) {
        $transaction->rollBack();
        throw $e;
        die('failed');
    }
             // do your magic
    $unlock = $connection-> createCommand('UNLOCK TABLES');
}


        // next move

        if ($documents[$kept_index] == 4 && $stamp[$kept_index] == 4) // if this document is a payment voucher and logged in user is finisher
        {
            // document or instrument is purchase order debit




            // $plan=Leap::find()->where(['cid'=>Yii::$app->user->identity->cid])->andWhere(['staff'=>Yii::$app->user->identity->id])->andWhere(['se'=>2])->one();

$plan=Twin::find()->where(['cid'=>Yii::$app->user->identity->cid])->one();

               // put this back for acrual if($plan==NULL || $plan->debit_code<=0 || $plan->credit_code<=0 ){ die('Please go back and select accounts to debit and credit'); }

// or put this back for acrual 
if($plan==NULL || $plan->debit_expense<=0 || $plan->credit_expense<=0 ){ die('Please go back and select accounts to debit and credit'); }

    

            $chart_account=$plan->debit_expense;
            $chart_account2=$plan->credit_expense;

            if($account_type=='cash'){
                $chart_account=800000000;
                $chart_account2=800000000;
            }


            $transaction = Yii::$app->db->beginTransaction();
            try {

                foreach (json_decode($work->requested_item, true) as $item) {
                    $total += $item['total'];
                    // $goods.=$item['item_name'].', ';
                    // $qty+=$item['quantity'];
                    // $qty2=$item['quantity'];

                }

                $lcheck=Ledger::find()->where(['transaction_id'=>$work->transaction_id])->one();
                if(!empty($lcheck))
                {
                 throw new \Exception('Inovoice already exists in Cashbook!');
             }

             if (count($leg) > 0) {
                $ledger = new Ledger();
                $ledger->debit = $total;
                $ledger->credit = 0;
                $ledger->department = Yii::$app->user->identity->department;
                $ledger->cid = Yii::$app->user->identity->cid;
                $ledger->created_at = date('Y-m-d');
                $ledger->transaction_id = $work->transaction_id;
                $ledger->description = "Expenditure";
                $ledger->vendor = $mike;
                $ledger->staff=Yii::$app->user->identity->id;
                $ledger->ptype = 2;
                $ledger->chart_account=$chart_account;
                $ledger->chart_account2=$chart_account2;
                $ledger->invoice=$invoice_id;

                if(empty($lcheck)){
                    if (!$ledger->save()) {
                        throw new \Exception('could not save to ledger');
                    }
                }
            } else {
                die('An opening balance has not been set!');
            }

                // entry stuff
$plan=Twin::find()->where(['cid'=>Yii::$app->user->identity->cid])->one();
$chart_account=$plan->debit_expense;
$chart_account2=$plan->credit_expense;

            $this->post_purchase_order_to_entry($chart_account,$chart_account2,$total,$ledger,$work,$vendor,$account_type);

      // send expense notification
            $this->expense_notification($workflow,$total);



                // } // close if last occurence of finisher in
            $transaction->commit();

        } catch (\Exception $e) {
            $transaction->rollBack();
            throw $e;
            die('failed');
        } catch (\Throwable $e) {
            $transaction->rollBack();
            throw $e;
            die('failed');
        }
    }


        // after that

        // do reciever moves

    if ($stamp[$kept_index] == 5 && $work->task_type == 1) {


     if(empty($invoice_id)){ die('Please go back and enter an invoice number'); }

     $transaction = Yii::$app->db->beginTransaction();
     try { $ukept=null;
        foreach (json_decode($work->requested_item, true) as $item) {
            $total += $item['total'];
            $goods .= $item['item_name'] . ', ';
            $qty += $item['quantity'];
            $qty2 = $item['quantity'];

            if ($work->task_type == 1) {
                $uti = Stores::findOne($item['item_id']);
                $ukept=$uti->quantity;
                $uti->cost_price=$item['amount'];

                if ($uti->countable == 1) {
                    $uti->quantity += $qty2;
                    if (!$uti->save()) {

                        throw new \Exception('could not save to store');
                    }


                }
            }


            if ($work->task_type == 1 && $stamp[$kept_index] == 5) {
                $row11 = explode(',', $workflow->status_id);
                $row22 = explode(',', $workflow->int_workflow);
                $reid = array_search(5, $row11);
                $rere = $row22[$reid];

                $uti = Stores::findOne($item['item_id']);

                if ($uti->countable == 1) {
                    $storeh = new StoresHistory();
                    $storeh->name = $uti->name;
                    $storeh->cid = $uti->cid;
                    $storeh->units = $uti->units;
                    $storeh->standing_quantity = $ukept;
                    $storeh->particulars = $uti->particulars;
                        // $storeh->received_date=date('Y-m-d');
                        // $storeh->recieved_by=$uti->recieved_by;
                    $storeh->recieved_by = $rere;
                    $storeh->transaction_id = $uti->transaction_id;
                    $storeh->balance = $uti->balance;
                    $storeh->transaction_quantity = $qty2;
                    $storeh->issued_date = date('Y-m-d');
                    $storeh->description = $uti->description;
                    $storeh->vendor = $hop[0]['vendor'];
                        $storeh->type = 12; // store is increasing
                        $storeh->qin = $qty2;
                        $storeh->issued_by = Yii::$app->user->identity->id;
                        $storeh->given_to = $uti->given_to;
                        $storeh->item_id = $uti->id;
                        if (!$storeh->save()) {
                            throw new \Exception('could not save to store');
                            
                        }


                    }

                }
            }

            $lego=Ledger::find()->where(['cid'=>Yii::$app->user->identity->cid,'transaction_id'=>$work->transaction_id])->one();
            $lego->invoice=$invoice_id;
            if(!$lego->save())
            {
                throw new \Exception('could not save invoice number to ledger');
            }
                // } // close if last occurence of finisher in
            $transaction->commit();

        } catch (\Exception $e) {
            $transaction->rollBack();
            throw $e;
            die('failed');
        } catch (\Throwable $e) {
            $transaction->rollBack();
            throw $e;
            die('failed');
        }

    }


        // next row


    if ($work->task_type == 6 && $stamp[$kept_index] == 5) {

        $transaction = Yii::$app->db->beginTransaction();
        try {
            foreach (json_decode($work->requested_item, true) as $item) {
                    // $goods.=$item['item_name'].', ';
                    // $qty+=$item['quantity'];
                $qty2=$item['quantity'];

                $store = Stores::findOne($item['item_id']); $storek=$store->quantity;
                $uti = Inventory::find()->where(['item_id' => $item['item_id']])->andWhere(['shop'=>$item['shop']])->one();
                if ($item['flow'] == 1) {
                    $checkit = Inventory::find()->where(['item_id' => $item['item_id']])->andWhere(['shop'=>$item['shop']])->one(); $qkept=$checkit->quantity;
                    if($store->quantity<$qty2 && $store->countable==1){ $available=1; }
// start
                    if($available==1)   {                                            


                        $dim = new Messages();
                        $dim->cid = Yii::$app->user->identity->cid;
                        $dim->from_id = Yii::$app->user->identity->id;
                        $dim->to_id = $work->raised_by;
                        $dim->subject = $work->title . ' Insufficient Quantities';
                        $dim->message = "One or more items on the invoice have Insufficient quantities";
                        $dim->message_link = $work->transaction_id;
                        if (!$dim->save()) {
                            throw new \Exception('could not save to messages');
                                                            //var_dump($dim->getErrors()); die;
                        }


                        ?>
                        <script type="text/javascript">
                            alert('Insufficient Quantity on one or more of the Voucher Items. Transaction has been rejected!'); 
                        </script>

                        <?php


                    }
                    

                    if($available==1)
                    {                        
                        $work->status = $work->raised_by;
                        $work->rejected = 1; $work->concluded=0;
                        $work->instrument = $documents[0];
                        $work->current_index = 10000;
                        $work->save();


                            // throw new \Exception('Insufficient quantity on one of the items in invoice');
                        
                    }
//stop
                         if($available==0){ // if ava
                            if ($checkit == null) {
                                $go = new Inventory();
                                $go->name = $item['item_name'];
                                $go->item_id = $item['item_id'];
                                $go->cid = Yii::$app->user->identity->cid;
                                if($item['countable']==1){
                                    $go->quantity = $item['quantity'];
                                }else{
                                 $go->quantity = 1;
                             }
                             $go->staff = Yii::$app->user->identity->id;
                             $go->description = $item['description'];
                             $go->countable = 0;
                             $go->price = 0;
                             $go->countable = $item['countable'];
                             $go->shop=$item['shop'];
                             $go->shop_type=$item['shop_type'];
                             $go->created_at = date("Y-m-d H:i:s");
                             if(!$go->save())
                             {
                                throw new \Exception('could not save to inventory new entery');
                            }



                        } else {
                         if ($item['countable'] == 1) {
                            $checkit->quantity += $item['quantity'];
                            if (!$checkit->save()) {
                                throw new \Exception('could not save to inventory');
                            }

                        }
                    }
                    // record stuff in shop history
                    if($item['countable']==1){
                        $shoph = new ShopHistory();
                        $shoph->cid = Yii::$app->user->identity->cid;
                        $shoph->name = $item['item_name'];
                        $shoph->quantity = $item['quantity'];

                        $shoph->price = 0;
                        $shoph->staff = Yii::$app->user->identity->id;
                    // $storeh->received_date=date('Y-m-d');
                        $shoph->created_at = date('Y-m-d');
                        $shoph->item_id = $item['item_id'];
                        $shoph->issued_by = Yii::$app->user->identity->id;
                        $shoph->received_by = $work->raised_by;
                    $shoph->type = 1; // increasing shop quantity
                    $shoph->transaction_id = $work->transaction_id;
                    $shoph->qin=$qty2;
                    ($qkept!=null && $qkept>0) ?  $shoph->standing_quantity=$qkept : $shoph->standing_quantity=0;

                    $shoph->countable = 0;


                    if (!$shoph->save()) {
                        throw new \Exception('could not save to shop history');
                        
                    }
                }


                    // store history
                $row11 = explode(',', $workflow->status_id);
                $row22 = explode(',', $workflow->int_workflow);
                $reid = array_search(5, $row11);
                $rere = $row22[$reid];

                if($item['countable']==1){
                    $storeh = new StoresHistory();
                    $storeh->name = $item['item_name'];
                    $storeh->cid = Yii::$app->user->identity->cid;
                    $storeh->units = 'store to shop';
                    $storeh->standing_quantity = $store->quantity;
                    $storeh->particulars = 'store to shop';
                    // $storeh->received_date=date('Y-m-d');
                    // $storeh->recieved_by=$uti->recieved_by;
                    $storeh->recieved_by = $rere;
                    $storeh->transaction_id = $work->transaction_id;
                    $storeh->balance = $item['quantity'];
                    $storeh->transaction_quantity = $item['quantity'];
                    $storeh->issued_date = date('Y-m-d');
                    $storeh->description = $uti->description;
                    $storeh->qout = $item['quantity'];
                    $storeh->type = 11; //reducing store

                    $storeh->issued_by = Yii::$app->user->identity->id;
                    $storeh->given_to = Yii::$app->user->identity->id;
                    $storeh->item_id = $item['item_id'];
                    if (!$storeh->save()) {
                        throw new \Exception('could not save to store history');


                    }
                }
            }

            if ($item['countable'] == 1) {
                $store->quantity -= $item['quantity'];



                if (!$store->save()) {
                    throw new \Exception('could not save to store');
                }
            }

                 } // item flow
             }

             $transaction->commit();

         } catch (\Exception $e) {
            $transaction->rollBack();
            throw $e;
            die('failed');
        } catch (\Throwable $e) {
            $transaction->rollBack();
            throw $e;
            die('failed');
        }

    }


        // end the product transfer       

    if($available==0){
        $work->status = $next_status;
        $work->rejected = 0;
        $work->instrument = $next_doc;
        $work->current_index = $current_index;
        $work->save();
    } 

    if($available==0){
        return $this->redirect(['requisitions/viewrequisition', 'id' => $id, 'doc' => $doc]);
    }
}


function sales_to_ledger($work,$leg,$item,$chart_account,$chart_account2,$total,$customer){
 $lcheck=Ledger::find()->where(['transaction_id'=>$work->transaction_id])->one();
 if(!empty($lcheck))
 {
     throw new \Exception('Inovoice already exists in Cashbook!');
 }


 if (count($leg) > 0) {
    $ledger = new Ledger();
    $ledger->debit = 0;
    $ledger->credit = $total;
    $ledger->department = Yii::$app->user->identity->department;
    $ledger->cid = Yii::$app->user->identity->cid;
    $ledger->created_at = date('Y-m-d');
    $ledger->transaction_id = $work->transaction_id;
    $ledger->vendor = $customer;
    $ledger->amount_paid = $item['amount_paid'];
    $ledger->description = "Income";
    $ledger->shop_id=$item['shop_id'];
    $ledger->staff=Yii::$app->user->identity->id;
    $ledger->chart_account=$chart_account;
    $ledger->chart_account2=$chart_account2;

    $ledger->ptype = 1;


    if(empty($lcheck)){
        if (!$ledger->save()) {
                            //var_dump($ledger->getErrors()); die;
            throw new \Exception('could not save to ledger');
        }
    }
} else {
    echo count($leg);
    die('An opening balance has not been set!'); 
}
}


// post sales transaction to entry table
function post_sales_debit_credit($chart_account,$chart_account2,$work,$narate,$total){
 $ac1=Charts::findOne($chart_account);
 $ac2=Charts::findOne($chart_account2);

 $entry_group=$ac1->atype;
 $entry_group2=$ac2->atype;

 $account_group=$ac1->account_group;
 $account_group2=$ac2->account_group; 

 $entry_type=1;

 if($account_type=='cash'){
    $entry_group=80;
    $entry_group2=80;

    $account_group=800;
    $account_group2=800;
}

if($entry_type==1 && ($entry_group==2 || $entry_group==3 || $entry_group==4))
{
    $total=($total*-1);
}
if($entry_type==2 && ($entry_group==1 || $entry_group==5))
{
    $total=($total*-1);
} 

$enter = new Entry;
$enter->amount=$total;
$enter->entry_type=1;
$enter->entry_group=$entry_group;
$enter->chart_account=$chart_account;       

$enter->account_group=$account_group;
$enter->who=Yii::$app->user->identity->id;
$enter->cid=Yii::$app->user->identity->cid;
$enter->created_at=date('Y-m-d');
$enter->fid=$ledger->id;
$enter->dsource='fd';
$enter->transaction_id=$work->transaction_id;
$enter->details = 'Client invoicing: '.$narate;

if(!$enter->save())
{
  var_dump($enter->getErrors()); die;
          //throw new \Exception('Could not save entry');
}

        // second entry

$total=abs($total);
        // entry 2
$entry_type2=2;
if($entry_type2==1 && ($entry_group2==2 || $entry_group2==3 || $entry_group2==4))
{
    $total=($total*-1);
}
if($entry_type2==2 && ($entry_group2==1 || $entry_group2==5))
{
    $total=($total*-1);
}


$enter2 = new Entry;
$enter2->amount=$total;
$enter2->entry_type=2;
$enter2->entry_group=$entry_group2;
$enter2->chart_account=$chart_account2;

$enter2->account_group=$account_group2;
$enter2->who=Yii::$app->user->identity->id;
$enter2->cid=Yii::$app->user->identity->cid;
$enter2->created_at=date('Y-m-d');
$enter2->fid=$ledger->id;
$enter2->dsource='fd';
$enter2->transaction_id=$work->transaction_id;
$enter2->details = 'Client invoicing: '.$narate;
if(!$enter2->save())
{

  throw new \Exception('Could not save entry2');
}
$total=abs($total);
}


          //  send purchase notification



function expense_notification($workflow,$total){
    $dnotice = explode(',', $workflow->notices);
    if (count($dnotice) > 0 && $dnotice[0] != Null) {
        foreach ($dnotice as $note) {
            $notify = new Notifications();
            $notify->cid = Yii::$app->user->identity->cid;
            $notify->notify = $note;
            $notify->link = $work->transaction_id;
            $notify->action_by = Yii::$app->user->identity->id;
            $notify->req_id = $work->id;
            $notify->doc_id = $work->instrument;
            $notify->workflow_id = $work->workflow_id;
            $notify->concluded = $work->concluded;
            $notify->rejected = $work->rejected;
            $notify->message = $total . "  has been disbursed by " . User::findOne(Yii::$app->user->identity->id)->last_name;
            if (!$notify->save()) {
                            //var_dump($notify->getErrors()); die;
                throw new \Exception('could not save notification');
            }
        }

    }
}


function post_purchase_order_to_entry($chart_account,$chart_account2,$total,$ledger,$work,$vendor,$account_type)
{


 $ac1=Charts::findOne($chart_account);
 $ac2=Charts::findOne($chart_account2);

 $entry_group=$ac1->atype;
 $entry_group2=$ac2->atype;

 $account_group=$ac1->account_group;
 $account_group2=$ac2->account_group;
 $entry_type=1;


 if($account_type=='cash'){
    $entry_group=80;
    $entry_group2=80;

    $account_group=800;
    $account_group2=800;
}

if($entry_type==1 && ($entry_group==2 || $entry_group==3 || $entry_group==4))
{
    $total=($total*-1);
}
if($entry_type==2 && ($entry_group==1 || $entry_group==5))
{
    $total=($total*-1);
} 

$enter = new Entry;
$enter->amount=$total;
$enter->entry_type=1;
$enter->entry_group=$entry_group;
$enter->chart_account=$chart_account;       

$enter->account_group=$account_group;
$enter->who=Yii::$app->user->identity->id;
$enter->cid=Yii::$app->user->identity->cid;
$enter->created_at=date('Y-m-d');
$enter->fid=$ledger->id;
$enter->dsource='fc';
$enter->transaction_id=$work->transaction_id;
$enter->details = 'Purchase transaction on: '.$vendor;

if(!$enter->save())
{
          var_dump($enter->getErrors()); die;
  // throw new \Exception('Could not save entry');
}

        // second entry

$total=abs($total);
        // entry 2
$entry_type2=2;
if($entry_type2==1 && ($entry_group2==2 || $entry_group2==3 || $entry_group2==4))
{
    $total=($total*-1);
}
if($entry_type2==2 && ($entry_group2==1 || $entry_group2==5))
{
    $total=($total*-1);
}


$enter2 = new Entry;
$enter2->amount=$total;
$enter2->entry_type=2;
$enter2->entry_group=$entry_group2;
$enter2->chart_account=$chart_account2;

$enter2->account_group=$account_group2;
$enter2->who=Yii::$app->user->identity->id;
$enter2->cid=Yii::$app->user->identity->cid;
$enter2->created_at=date('Y-m-d');
$enter2->fid=$ledger->id;
$enter2->dsource='fc';
$enter2->transaction_id=$work->transaction_id;
$enter2->details = 'Purchase transaction on : '.$vendor;
if(!$enter2->save())
{
          //var_dump($enter2->getErrors()); die;
  throw new \Exception('Could not save entry2');
}
$total=abs($total);
}



public function actionDecline($id, $doc)
{
    $work = Requisitions::findOne($id);
    $workflow = Workflow::findOne($work->workflow_id);


    $flows = explode(',', $workflow->int_workflow);
    $next_status = '';
        // var_dump($flows); die;
    $current_index = $work->current_index;
    $kept_index = $work->current_index;
        //$index=array_search(Yii::$app->user->identity->id,$flows);
        //echo $index; echo " added ".$flows[$index+1]; 
    $index = $current_index;
    if (isset($flows[$index - 1])) {
        $next_status = $flows[$index - 1];


    } else {
        $next_status = $flows[$kept_index];
    }
        // echo  Yii::$app->user->identity->id;
        // echo " next status is ".($index-1); die;

    $documents = explode(',', $workflow->instrument);
    $next_doc = '';

        //$index_doc=array_search($doc,$documents);
    $index_doc = $current_index;

    if (isset($documents[$index_doc - 1])) {
        $next_doc = $documents[$index_doc - 1];
        $current_index -= 1;
    } else {
        $next_doc = $documents[$kept_index];
            // $work->concluded=1;

    }

    $work->status = $next_status;
    $work->rejected = 1;
    $work->instrument = $next_doc;
    $work->current_index = $current_index;
    $work->save();

        // $notify= new Notifications();
        // $notify->to_be_notified=$work->raised_by.','.$work->not_seen;
        // $notify->cid=$work->workflow_id;
        // $notify->document_id=$work->id;
        // $notify->transaction_id=$work->transaction_id;
        // $notify->action_taken_by=Yii::$app->user->identity->id;
        // $notify->notification_details=RequisitionTypes::findOne($work->requisition_type)->requisition_type;

        // $notify->is_approved=0;
        // if(!$notify->save())
        // {
        //     var_dump($notify->getErrors()); die;
        // }

    return $this->redirect(['requisitions/viewrequisition', 'id' => $id, 'doc' => $doc]);
}


public function actionDecline2()
{

        //var_dump(Yii::$app->request->get()); die;

    $id = Yii::$app->request->get('record_id');
    $doc = Yii::$app->request->get('instrumente');
    $message = Yii::$app->request->get('messager');

    $work = Requisitions::findOne($id);
    $workflow = Workflow::findOne($work->workflow_id);


    $flows = explode(',', $workflow->int_workflow);
    $next_status = '';

    $current_index = $work->current_index;
    $kept_index = $work->current_index;


    $index = $current_index;
        // if a requisition is rejected just send it back to originatior using line below
    $next_status = $work->raised_by;


    $documents = explode(',', $workflow->instrument);
    $next_doc = '';


    $index_doc = $current_index;


    $next_doc = $documents[$kept_index];


    $transaction = Yii::$app->db->beginTransaction();
    try {
        $work->status = $work->raised_by;
        $work->rejected = 1;
        $work->instrument = $documents[0];
        $work->current_index = 0;
        if (!$work->save()) {
            throw new \Exception('could not save to workflow');
        }


        if ($workflow->notices != NULL) {
            $dnotice = explode(',', trim($workflow->notices));

            foreach ($dnotice as $note) {
                $notify = new Notifications();
                $notify->cid = Yii::$app->user->identity->cid;
                $notify->notify = $note;
                $notify->link = $work->transaction_id;
                $notify->action_by = Yii::$app->user->identity->id;
                $notify->req_id = $work->id;
                $notify->doc_id = $work->instrument;
                $notify->workflow_id = $work->workflow_id;
                $notify->concluded = $work->concluded;
                $notify->rejected = $work->rejected;
                $notify->message = 'Requisition rejected';
                if (!$notify->save()) {
                    throw new \Exception('could not save to notifications');
                        //var_dump($notify->getErrors()); die;
                }
            }
        }


            // send message to person who raised requisition


        if (!empty($message)) {
            $dim = new Messages();
            $dim->cid = Yii::$app->user->identity->cid;
            $dim->from_id = Yii::$app->user->identity->id;
            $dim->to_id = $work->raised_by;
            $dim->subject = $work->title . ' Requisition rejected';
            $dim->message = $message;
            $dim->message_link = $work->transaction_id;
            if (!$dim->save()) {
                throw new \Exception('could not save to messages');
                    //var_dump($dim->getErrors()); die;
            }

        }


        $transaction->commit();

    } catch (\Exception $e) {
        $transaction->rollBack();
        throw $e;
        die('failed');
    } catch (\Throwable $e) {
        $transaction->rollBack();
        throw $e;
        die('failed');
    }


    return $this->redirect(['requisitions/viewrequisition', 'id' => $id, 'doc' => $doc]);
}


public function actionMyrequisitions()
{
    $requisitions = Requisitions::find()->where(['=', 'cid', Yii::$app->user->identity->cid])->andWhere(['=', 'raised_by', Yii::$app->user->id])->orderBy('id desc')->all();
    return $this->render('my_requisitions', ['requisitions' => $requisitions]);
}


public function actionAllrequisitions()
{

    $requisitions = Requisitions::find()->where(['=', 'cid', Yii::$app->user->identity->cid])->orderBy('id desc')->limit(5)->all();        // start

    $from=Yii::$app->request->post('from');
    $to=Yii::$app->request->post('to'); 
    $tid=Yii::$app->request->post('tid');
    $status=Yii::$app->request->post('status');
    $task_type=Yii::$app->request->post('task_type');    

    if(Yii::$app->request->post()){ 
      $query = Requisitions::find()->where(['=','cid',Yii::$app->user->identity->cid]);

      if(Yii::$app->request->post('from') && Yii::$app->request->post('to'))
      {
        $query=$query->andWhere(['between','SUBSTR(created_at,1,10)',$from,$to]);
    }

    if(Yii::$app->request->post('tid')){
        $query=$query->andWhere(['transaction_id'=>$tid]);
    }

    if(Yii::$app->request->post('status')){
        if($status==1){  
            $query=$query->andWhere(['concluded'=>1]);
        }
        if($status==2){  
            $query=$query->andWhere(['rejected'=>1]);
        }
        if($status==3){  
            $query=$query->andWhere(['concluded'=>0])->andWhere(['rejected'=>0]);
        }
    }

    if(Yii::$app->request->post('task_type')){
        $query=$query->andWhere(['task_type'=>$task_type]);
    }

    $query=$query->all();
    return $this->render('all_requisitions', ['requisitions' => $query]);
}else{


        // stop
    return $this->render('all_requisitions', ['requisitions' => $requisitions]);
}

}


public function actionRequisitiondetails($tid, $doc)
{
    return $this->render('req_details', ['doc' => $doc, 'tid' => $tid]);
}

//    $2y$13$Osp0WuH3.FkozP3lLGjdlOZY3ao8HQ448dYyMKZ4nauU0s0wiqncW
public function actionPnl()
{
    if (isset($_POST['sent'])) {

        $date1 = $_POST['from'];
        $date2 = $_POST['to'];

        $command = Yii::$app->db->createCommand("SELECT sum(amount_paid) as amount_paid, ptype, chart_account, chart_account2, vendor, tlink FROM ledger where substr(created_at,1,10) >= '".$_POST['from']."' and substr(created_at,1,10) <='".$_POST['to']."' and ptype=1 and amount_paid>0 && cid='".Yii::$app->user->identity->cid."' group By chart_account, chart_account2");
        $income = $command->queryAll(); 

        $command2 = Yii::$app->db->createCommand("SELECT sum(amount_paid) as amount_paid, ptype, chart_account, chart_account2, vendor, tlink FROM ledger where substr(created_at,1,10) >= '".$_POST['from']."' and substr(created_at,1,10) <='".$_POST['to']."' and ptype=2 && amount_paid>0 && cid='".Yii::$app->user->identity->cid."' group By chart_account, chart_account2");
        $expenditure = $command2->queryAll();

        $command3 = Yii::$app->db->createCommand("SELECT sum(amount_paid) as amount_paid FROM ledger where substr(created_at,1,10) >= '".$_POST['from']."' and substr(created_at,1,10) <='".$_POST['to']."' and ptype=1 and amount_paid>0 && cid='".Yii::$app->user->identity->cid."'");
        $total_income = $command3->queryScalar(); 

        $command4 = Yii::$app->db->createCommand("SELECT sum(amount_paid) as amount_paid FROM ledger where substr(created_at,1,10) >= '".$_POST['from']."' and substr(created_at,1,10) <='".$_POST['to']."' and ptype=2 and amount_paid>0 && cid='".Yii::$app->user->identity->cid."'");
        $total_exp = $command4->queryScalar();

        //  $idetails_sql="select sum(amount_paid) as amount_paid, transaction_date, description, transaction_type from fees where transaction_date between '".$date1."' and '".$date2."' && cid='".Yii::app()->user->cid."' group by transaction_type";
        //  $income_details = Yii::app()->db->createCommand($idetails_sql)->queryAll(); 


        $accounts="select id, anumber from charts where anumber like '4%' and cid='".Yii::$app->user->identity->cid."'"; 
        $a; 
        $cup2=array();
        $cup = Yii::$app->db->createCommand($accounts)->queryAll(); 
        foreach($cup as $cu){ $a.="'".$cu['id']."',";   }
        $b=rtrim($a,',');   

        $cap_sql="select sum(amount) as amount, chart_account, id, fid, entry_type, entry_group, dsource from entry where chart_account in (".$b.") and substr(created_at,1,10) between '".$_POST['from']."' and '".$_POST['to']."' && cid='".Yii::$app->user->identity->cid."' group by chart_account  ";          
        $income_details2=Yii::$app->db->createCommand($cap_sql)->queryAll(); 
        //var_dump($income_details2); die;

        // expense 2

        $accounts2="select id, anumber from charts where anumber like '5%' and cid='".Yii::$app->user->identity->cid."'";     
        $a2; 
        $cup3=array();
        $cup4 = Yii::$app->db->createCommand($accounts2)->queryAll(); 
        foreach($cup4 as $cu2){ $a2.="'".$cu2['id']."',";   }
        $b2=rtrim($a2,',');   

        $exp2_sql="select sum(amount) as amount, chart_account, id, fid, entry_type, entry_group, dsource from entry where chart_account in (".$b2.") and substr(created_at,1,10) between '".$_POST['from']."' and '".$_POST['to']."' && cid='".Yii::$app->user->identity->cid."' group by chart_account  ";            
        $expense_details=Yii::$app->db->createCommand($exp2_sql)->queryAll(); 

        // this is for cash accounting approach and does not include accounts payable or receivable

        $cap_sql3="select amount_paid as amount, transaction_id, created_at, chart_account, chart_account2, id, entry_type, entry_group, credit from ledger where substr(created_at,1,10) between '".$_POST['from']."' and '".$_POST['to']."' && cid='".Yii::$app->user->identity->cid."' and amount_paid>0 and ptype=1 and chart_account IS NOT NULL and chart_account2 IS NOT NULL  ";          
        $income_details3=Yii::$app->db->createCommand($cap_sql3)->queryAll(); 


        $exp2_sql3="select sum(amount_paid) as amount, chart_account, chart_account2 id, entry_type, entry_group from ledger where substr(created_at,1,10) between '".$_POST['from']."' and '".$_POST['to']."' && cid='".Yii::$app->user->identity->cid."' and amount_paid>0 and ptype=2 and chart_account IS NOT NULL and chart_account2 IS NOT NULL group by chart_account, chart_account2  ";            
        $expense_details3=Yii::$app->db->createCommand($exp2_sql3)->queryAll();

        // detailed listing


         $cap_sql3p="select amount_paid as amount, chart_account, chart_account2, id, entry_type, entry_group, credit, transaction_id from ledger where substr(created_at,1,10) between '".$_POST['from']."' and '".$_POST['to']."' && cid='".Yii::$app->user->identity->cid."' and amount_paid>0 and ptype=1 and chart_account IS NOT NULL and chart_account2 IS NOT NULL";          
        $income_details3p=Yii::$app->db->createCommand($cap_sql3p)->queryAll(); 


        $exp2_sql3p="select amount_paid as amount, chart_account, chart_account2, id, entry_type, entry_group, transaction_id from ledger where substr(created_at,1,10) between '".$_POST['from']."' and '".$_POST['to']."' && cid='".Yii::$app->user->identity->cid."' and amount_paid>0 and ptype=2 and chart_account IS NOT NULL and chart_account2 IS NOT NULL";            
        $expense_details3p=Yii::$app->db->createCommand($exp2_sql3p)->queryAll(); 

    }


    return $this->render('pnl', ['income' => $income, 'expenditure' => $expenditure, 'total_income' => $total_income, 'total_exp' => $total_exp,'from'=>$_POST['from'],'to'=>$_POST['to'],'income_details2'=>$income_details2,'expense_details'=>$expense_details,'income_details3'=>$income_details3,'expense_details3'=>$expense_details3,'income_details3p'=>$income_details3p,'expense_details3p'=>$expense_details3p,'date1'=>$date1,'date2'=>$date2]);
}

public function actionPnld()
{
       // die('MRLSOFT not found');
    if (isset($_POST['sent'])) {
        

        $command = Yii::$app->db->createCommand("SELECT amount_paid, ptype, chart_account, chart_account2, vendor, tlink FROM ledger where substr(created_at,1,10) >= '".$_POST['from']."' and substr(created_at,1,10) <='".$_POST['to']."' and ptype=1 and amount_paid>0 && cid='".Yii::$app->user->identity->cid."'");
        $income = $command->queryAll(); 

         // $edetails_sql="select amount, date_paid_out, description, expense_type,id from Expenses where date_paid_out between '".$date1."' and '".$date2."' && cid='".Yii::app()->user->cid."' and amount>0";
         // $expense_details = Yii::app()->db->createCommand($edetails_sql)->queryAll();


        $command2 = Yii::$app->db->createCommand("SELECT amount_paid, ptype, chart_account, chart_account2, vendor, tlink, created_at FROM ledger where substr(created_at,1,10) >= '".$_POST['from']."' and substr(created_at,1,10) <='".$_POST['to']."' and ptype=2 && amount_paid>0 && cid='".Yii::$app->user->identity->cid."'");
        $expenditure = $command2->queryAll();

        $command3 = Yii::$app->db->createCommand("SELECT sum(amount_paid) as amount_paid FROM ledger where substr(created_at,1,10) >= '".$_POST['from']."' and substr(created_at,1,10) <='".$_POST['to']."' and ptype=1 and amount_paid>0 && cid='".Yii::$app->user->identity->cid."'");
        $total_income = $command3->queryScalar(); 

        $command4 = Yii::$app->db->createCommand("SELECT sum(amount_paid) as amount_paid FROM ledger where substr(created_at,1,10) >= '".$_POST['from']."' and substr(created_at,1,10) <='".$_POST['to']."' and ptype=2 and amount_paid>0 && cid='".Yii::$app->user->identity->cid."'");
        $total_exp = $command4->queryScalar();

        //  $idetails_sql="select sum(amount_paid) as amount_paid, transaction_date, description, transaction_type from fees where transaction_date between '".$date1."' and '".$date2."' && cid='".Yii::app()->user->cid."' group by transaction_type";
        //  $income_details = Yii::app()->db->createCommand($idetails_sql)->queryAll(); 


        $idetails_sql="select  *from entry where created_at between '".$_POST['from']."' and '".$_POST['to']."' && cid='".Yii::$app->user->identity->cid."' and (entry_type=1 and chart_account=30) || (chart_account=57 and entry_type=1)";
        $income_details = Yii::$app->db->createCommand($idetails_sql)->queryAll(); 


    }


    return $this->render('pnld', ['income' => $income, 'expenditure' => $expenditure, 'total_income' => $total_income, 'total_exp' => $total_exp,'from'=>$_POST['from'],'to'=>$_POST['to'],'income_details'=>$income_details]);
}

public function actionAttentionrequired()
{
    $requisitions = Requisitions::find()->where(['=', 'cid', Yii::$app->user->identity->cid])->andWhere(['=', 'status', Yii::$app->user->identity->id])->andWhere(['=', 'concluded', 0])->andWhere(['=', 'rejected', 0])->orderBy('id desc')->all();
    return $this->render('list_requisitions', ['requisitions' => $requisitions]);
}

public function actionAllrejections()
{
    $requisitions = Requisitions::find()->where(['=', 'cid', Yii::$app->user->identity->cid])->andWhere(['=', 'status', Yii::$app->user->identity->id])->andWhere(['!=', 'concluded', 1])->andWhere(['=', 'rejected', 1])->orderBy('id desc')->all();
    return $this->render('allrejections', ['requisitions' => $requisitions]);
}

public function actionAllnotifications()
{
    $requisitions = Notifications::find()->where(['=', 'notify', Yii::$app->user->identity->id])->andWhere(['=', 'status', 0])->all();
    return $this->render('allnotifications', ['requisitions' => $requisitions]);
}


public function actionOutflow()
{
    return $this->render('outflow');
}


public function actionDecline2_kept()
{

        //var_dump(Yii::$app->request->get()); die;

    $id = Yii::$app->request->get('record_id');
    $doc = Yii::$app->request->get('instrumente');
    $message = Yii::$app->request->get('messager');

    $work = Requisitions::findOne($id);
    $workflow = Workflow::findOne($work->workflow_id);


    $flows = explode(',', $workflow->int_workflow);
    $next_status = '';
        // var_dump($flows); die;
    $current_index = $work->current_index;
    $kept_index = $work->current_index;
        //$index=array_search(Yii::$app->user->identity->id,$flows);
        //echo $index; echo " added ".$flows[$index+1]; 

    $index = $current_index;
    if (isset($flows[$index - 1])) {
        $next_status = $flows[$index - 1];


    } else {
        $next_status = $flows[$kept_index];
    }
        // echo  Yii::$app->user->identity->id;
        // echo " next status is ".($index-1); die;

    $documents = explode(',', $workflow->instrument);
    $next_doc = '';

        //$index_doc=array_search($doc,$documents);
    $index_doc = $current_index;

    if (isset($documents[$index_doc - 1])) {
        $next_doc = $documents[$index_doc - 1];
        $current_index -= 1;
    } else {
        $next_doc = $documents[$kept_index];
            // $next_doc=$work->raised_by;
            // $work->concluded=1;

    }

    $work->status = $work->raised_by;
    $work->rejected = 1;
    $work->instrument = $next_doc;
    $work->current_index = $current_index;
    $work->save();

    $dnotice = explode(',', $workflow->notices);
    foreach ($dnotice as $note) {
        $notify = new Notifications();
        $notify->cid = Yii::$app->user->identity->cid;
        $notify->notify = $note;
        $notify->link = $work->transaction_id;
        $notify->action_by = Yii::$app->user->identity->id;
        $notify->req_id = $work->id;
        $notify->doc_id = $work->instrument;
        $notify->workflow_id = $work->workflow_id;
        $notify->concluded = $work->concluded;
        $notify->rejected = $work->rejected;
        $notify->message = 'Requisition rejected';
        if (!$notify->save()) {
            var_dump($notify->getErrors());
            die;
        }
    }


        // send message to person who raised requisition


    if (!empty($message)) {
        $dim = new Messages();
        $dim->cid = Yii::$app->user->identity->cid;
        $dim->from_id = Yii::$app->user->identity->id;
        $dim->to_id = $work->raised_by;
        $dim->subject = $work->title . ' Requisition rejected';
        $dim->message = $message;
        $dim->message_link = $work->transaction_id;
        if (!$dim->save()) {
            var_dump($dim->getErrors());
            die;
        }

    }


    return $this->redirect(['requisitions/viewrequisition', 'id' => $id, 'doc' => $doc]);
}

public function actionLand()
{
    return $this->render('land');
}

public function actionEditr()
{

    if (Yii::$app->request->post()) {
        $posts = Yii::$app->request->post();


        for ($x = 0; $x < count($posts['item_id']); $x++) {
            $total = 0;
            $total += $posts['quantity'][$x] * $posts['amount'][$x];
            if (empty($posts['customer'])) {
                $item[] = array('total' => $total, 'amount' => $posts['amount'][$x], 'details' => $posts['details'][$x], 'quantity' => $posts['quantity'][$x], 'item_name' => $posts['item_name'][$x], 'item_id' => $posts['item_id'][$x], 'id' => $posts['item_id'][$x]);
            } else {
                $item[] = array('total' => $total, 'amount' => $posts['amount'][$x], 'details' => $posts['details'][$x], 'quantity' => $posts['quantity'][$x], 'item_name' => $posts['item_name'], 'item_id' => $posts['item_id'][$x], 'customer_name' => $posts['customer'], 'id' => $posts['item_id'][$x]);
            }
        }

        $point = Requisitions::findOne($posts['rec_id']);
        $point->requested_item = json_encode($item);
        if (!$point->save()) {
            var_dump($point->getErrors());
            die;
        } else {
            echo "its done " . $posts['rec_id'];
            return $this->redirect(['viewrejections', 'id' => $posts['rec_id'], 'doc' => 9]);
        }

    }

        //  var_dump($posts);

        //return $this->render('editr');
}


public function actionViewrejections($id, $doc)
{
    $record = Requisitions::findOne($id);
        // var_dump($record); die;
    $doca = $record->instrument;
    $see = $record->status;
    return $this->render('view_rejections', ['record' => $record, 'document' => $doca, 'see' => $see]);
}

public function actionEdelete()
{
    $id = Yii::$app->request->post('rec_id');
    $rec = Requisitions::findOne($id)->delete();
    return $this->redirect(['allrejections']);
}


public function actionRain()
{
    $invoice = Yii::$app->request->post('invoice');
    $id = Yii::$app->request->post('id');
    $instrument = Yii::$app->request->post('instrument');


    $session=Yii::$app->session;
    $session->open();
    $session['invo']=$invoice; 

    return $this->redirect(['approve','id'=>$id,'doc'=>$instrument]);
}


}
